/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import io.grpc.internal.WritableBuffer;
import okio.Buffer;

class OkHttpWritableBuffer
implements WritableBuffer {
    private final Buffer buffer;
    private int writableBytes;
    private int readableBytes;

    OkHttpWritableBuffer(Buffer buffer, int capacity) {
        this.buffer = buffer;
        this.writableBytes = capacity;
    }

    @Override
    public void write(byte[] src, int srcIndex, int length) {
        this.buffer.write(src, srcIndex, length);
        this.writableBytes -= length;
        this.readableBytes += length;
    }

    @Override
    public int writableBytes() {
        return this.writableBytes;
    }

    @Override
    public int readableBytes() {
        return this.readableBytes;
    }

    @Override
    public void release() {
    }

    Buffer buffer() {
        return this.buffer;
    }
}

