/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.DelayedStream;
import io.grpc.internal.ManagedClientTransport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

class DelayedClientTransport
implements ManagedClientTransport {
    private final Object lock = new Object();
    private ManagedClientTransport.Listener listener;
    private volatile ClientTransport delegate;
    @GuardedBy(value="lock")
    private Collection<PendingStream> pendingStreams = new HashSet<PendingStream>();
    @GuardedBy(value="lock")
    private Collection<PendingPing> pendingPings = new ArrayList<PendingPing>();
    @GuardedBy(value="lock")
    private boolean shutdown;

    DelayedClientTransport() {
    }

    @Override
    public void start(ManagedClientTransport.Listener listener) {
        this.listener = (ManagedClientTransport.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        ClientTransport transport = this.delegate;
        if (transport != null) {
            return transport.newStream(method, headers);
        }
        Object object = this.lock;
        synchronized (object) {
            transport = this.delegate;
            if (transport != null) {
                return transport.newStream(method, headers);
            }
            if (!this.shutdown) {
                PendingStream pendingStream = new PendingStream(method, headers);
                this.pendingStreams.add(pendingStream);
                return pendingStream;
            }
        }
        DelayedStream stream = new DelayedStream();
        stream.setError(Status.UNAVAILABLE.withDescription("transport shutdown"));
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        ClientTransport transport = this.delegate;
        if (transport != null) {
            transport.ping(callback, executor);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            transport = this.delegate;
            if (transport != null) {
                transport.ping(callback, executor);
                return;
            }
            if (!this.shutdown) {
                PendingPing pendingPing = new PendingPing(callback, executor);
                this.pendingPings.add(pendingPing);
                return;
            }
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(Status.UNAVAILABLE.withDescription("transport shutdown").asException());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            this.listener.transportShutdown(Status.OK.withDescription("Channel requested transport to shut down"));
            if (this.pendingStreams == null || this.pendingStreams.isEmpty()) {
                this.pendingStreams = null;
                this.listener.transportTerminated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow(Status status) {
        this.shutdown();
        Collection<PendingStream> savedPendingStreams = null;
        Iterator<PendingStream> iterator = this.lock;
        synchronized (iterator) {
            if (this.pendingStreams != null) {
                savedPendingStreams = this.pendingStreams;
                this.pendingStreams = null;
            }
        }
        if (savedPendingStreams != null) {
            for (PendingStream stream : savedPendingStreams) {
                stream.setError(status);
            }
            this.listener.transportTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransport(ClientTransport transport) {
        Collection<PendingStream> savedPendingStreams;
        Iterator<PendingStream> iterator = this.lock;
        synchronized (iterator) {
            Preconditions.checkState((this.delegate == null ? 1 : 0) != 0, (Object)"setTransport already called");
            Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"start() not called");
            this.delegate = (ClientTransport)Preconditions.checkNotNull((Object)transport, (Object)"transport");
            for (PendingPing ping : this.pendingPings) {
                ping.createRealPing(transport);
            }
            this.pendingPings = null;
            if (this.shutdown && this.pendingStreams != null) {
                this.listener.transportTerminated();
            }
            savedPendingStreams = this.pendingStreams;
            this.pendingStreams = null;
            if (!this.shutdown) {
                this.listener.transportReady();
            }
        }
        if (savedPendingStreams != null) {
            for (PendingStream stream : savedPendingStreams) {
                stream.createRealStream(transport);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getPendingStreamsCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams == null ? 0 : this.pendingStreams.size();
        }
    }

    private static class PendingPing {
        private final ClientTransport.PingCallback callback;
        private final Executor executor;

        public PendingPing(ClientTransport.PingCallback callback, Executor executor) {
            this.callback = callback;
            this.executor = executor;
        }

        public void createRealPing(ClientTransport transport) {
            try {
                transport.ping(this.callback, this.executor);
            }
            catch (UnsupportedOperationException ex) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        PendingPing.this.callback.onFailure(ex);
                    }
                });
            }
        }
    }

    private class PendingStream
    extends DelayedStream {
        private final MethodDescriptor<?, ?> method;
        private final Metadata headers;

        private PendingStream(MethodDescriptor<?, ?> method, Metadata headers) {
            this.method = method;
            this.headers = headers;
        }

        private void createRealStream(ClientTransport transport) {
            this.setStream(transport.newStream(this.method, this.headers));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void setError(Status reason) {
            Object object = DelayedClientTransport.this.lock;
            synchronized (object) {
                if (DelayedClientTransport.this.pendingStreams != null) {
                    DelayedClientTransport.this.pendingStreams.remove(this);
                    if (DelayedClientTransport.this.shutdown && DelayedClientTransport.this.pendingStreams.isEmpty()) {
                        DelayedClientTransport.this.pendingStreams = null;
                        DelayedClientTransport.this.listener.transportTerminated();
                    }
                }
            }
            super.setError(reason);
        }
    }
}

