/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.stub;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.Status;
import io.grpc.stub.Method;
import io.grpc.stub.StreamObserver;

public class ServerCalls {
    private ServerCalls() {
    }

    public static <ReqT, RespT> ServerMethodDefinition<ReqT, RespT> createMethodDefinition(Method<ReqT, RespT> method, ServerCallHandler<ReqT, RespT> handler) {
        return ServerMethodDefinition.create(method.getName(), method.getRequestMarshaller(), method.getResponseMarshaller(), handler);
    }

    public static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncUnaryRequestCall(final UnaryRequestMethod<ReqT, RespT> method) {
        return new ServerCallHandler<ReqT, RespT>(){

            @Override
            public ServerCall.Listener<ReqT> startCall(String fullMethodName, final ServerCall<RespT> call, Metadata.Headers headers) {
                final ResponseObserver responseObserver = new ResponseObserver(call);
                call.request(1);
                return new EmptyServerCallListener<ReqT>(){
                    ReqT request;

                    @Override
                    public void onPayload(ReqT request) {
                        if (this.request == null) {
                            this.request = request;
                            call.request(1);
                        } else {
                            call.close(Status.INVALID_ARGUMENT.withDescription("More than one request payloads for unary call or server streaming call"), new Metadata.Trailers());
                        }
                    }

                    @Override
                    public void onHalfClose() {
                        if (this.request != null) {
                            method.invoke(this.request, responseObserver);
                        } else {
                            call.close(Status.INVALID_ARGUMENT.withDescription("Half-closed without a request"), new Metadata.Trailers());
                        }
                    }

                    @Override
                    public void onCancel() {
                        responseObserver.cancelled = true;
                    }
                };
            }
        };
    }

    public static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncStreamingRequestCall(final StreamingRequestMethod<ReqT, RespT> method) {
        return new ServerCallHandler<ReqT, RespT>(){

            @Override
            public ServerCall.Listener<ReqT> startCall(String fullMethodName, final ServerCall<RespT> call, Metadata.Headers headers) {
                call.request(1);
                final ResponseObserver responseObserver = new ResponseObserver(call);
                final StreamObserver requestObserver = method.invoke(responseObserver);
                return new EmptyServerCallListener<ReqT>(){
                    boolean halfClosed = false;

                    @Override
                    public void onPayload(ReqT request) {
                        requestObserver.onValue(request);
                        call.request(1);
                    }

                    @Override
                    public void onHalfClose() {
                        this.halfClosed = true;
                        requestObserver.onCompleted();
                    }

                    @Override
                    public void onCancel() {
                        if (!this.halfClosed) {
                            requestObserver.onError(Status.CANCELLED.asException());
                        }
                        responseObserver.cancelled = true;
                    }
                };
            }
        };
    }

    private static class EmptyServerCallListener<ReqT>
    extends ServerCall.Listener<ReqT> {
        private EmptyServerCallListener() {
        }

        @Override
        public void onPayload(ReqT request) {
        }

        @Override
        public void onHalfClose() {
        }

        @Override
        public void onCancel() {
        }

        @Override
        public void onComplete() {
        }
    }

    private static class ResponseObserver<RespT>
    implements StreamObserver<RespT> {
        final ServerCall<RespT> call;
        volatile boolean cancelled;

        ResponseObserver(ServerCall<RespT> call) {
            this.call = call;
        }

        @Override
        public void onValue(RespT response) {
            if (this.cancelled) {
                throw Status.CANCELLED.asRuntimeException();
            }
            this.call.sendPayload(response);
            this.call.request(1);
        }

        @Override
        public void onError(Throwable t) {
            this.call.close(Status.fromThrowable(t), new Metadata.Trailers());
        }

        @Override
        public void onCompleted() {
            if (this.cancelled) {
                throw Status.CANCELLED.asRuntimeException();
            }
            this.call.close(Status.OK, new Metadata.Trailers());
        }
    }

    public static interface StreamingRequestMethod<ReqT, RespT> {
        public StreamObserver<ReqT> invoke(StreamObserver<RespT> var1);
    }

    public static interface UnaryRequestMethod<ReqT, RespT> {
        public void invoke(ReqT var1, StreamObserver<RespT> var2);
    }
}

