/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.netty;

import com.google.common.base.Preconditions;
import io.grpc.transport.Server;
import io.grpc.transport.ServerListener;
import io.grpc.transport.netty.NettyServerTransport;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class NettyServer
implements Server {
    private static final Logger log = Logger.getLogger(Server.class.getName());
    private final SocketAddress address;
    private final Class<? extends ServerChannel> channelType;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final SslContext sslContext;
    private final int maxStreamsPerConnection;
    private ServerListener listener;
    private Channel channel;
    private int connectionWindowSize;
    private int streamWindowSize;

    NettyServer(SocketAddress address, Class<? extends ServerChannel> channelType, EventLoopGroup bossGroup, EventLoopGroup workerGroup, int maxStreamsPerConnection, int connectionWindowSize, int streamWindowSize) {
        this(address, channelType, bossGroup, workerGroup, null, maxStreamsPerConnection, connectionWindowSize, streamWindowSize);
    }

    NettyServer(SocketAddress address, Class<? extends ServerChannel> channelType, EventLoopGroup bossGroup, EventLoopGroup workerGroup, @Nullable SslContext sslContext, int maxStreamsPerConnection, int connectionWindowSize, int streamWindowSize) {
        this.address = address;
        this.channelType = (Class)Preconditions.checkNotNull(channelType, (Object)"channelType");
        this.bossGroup = (EventLoopGroup)Preconditions.checkNotNull((Object)bossGroup, (Object)"bossGroup");
        this.workerGroup = (EventLoopGroup)Preconditions.checkNotNull((Object)workerGroup, (Object)"workerGroup");
        this.sslContext = sslContext;
        this.maxStreamsPerConnection = maxStreamsPerConnection;
        this.connectionWindowSize = connectionWindowSize;
        this.streamWindowSize = streamWindowSize;
    }

    @Override
    public void start(ServerListener serverListener) throws IOException {
        this.listener = serverListener;
        ServerBootstrap b = new ServerBootstrap();
        b.group(this.bossGroup, this.workerGroup);
        b.channel(this.channelType);
        if (NioServerSocketChannel.class.isAssignableFrom(this.channelType)) {
            b.option(ChannelOption.SO_BACKLOG, (Object)128);
            b.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        }
        b.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel ch) throws Exception {
                NettyServerTransport transport = new NettyServerTransport(ch, NettyServer.this.sslContext, NettyServer.this.maxStreamsPerConnection, NettyServer.this.connectionWindowSize, NettyServer.this.streamWindowSize);
                transport.start(NettyServer.this.listener.transportCreated(transport));
            }
        });
        ChannelFuture future = b.bind(this.address);
        try {
            future.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted waiting for bind");
        }
        if (!future.isSuccess()) {
            throw new IOException("Failed to bind", future.cause());
        }
        this.channel = future.channel();
    }

    @Override
    public void shutdown() {
        if (this.channel == null || !this.channel.isOpen()) {
            return;
        }
        this.channel.close().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    log.log(Level.WARNING, "Error shutting down server", future.cause());
                }
                NettyServer.this.listener.serverShutdown();
            }
        });
    }
}

