/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.netty;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.transport.netty.ProtocolNegotiator;
import io.grpc.transport.netty.Utils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2OrHttpChooser;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.ByteString;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public final class ProtocolNegotiators {
    private static final Logger log = Logger.getLogger(ProtocolNegotiators.class.getName());
    private static final List<String> SUPPORTED_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("h2", Http2OrHttpChooser.SelectedProtocol.HTTP_2.protocolName(), "h2-14", "h2-15", "h2-16"));
    private static final String[] JETTY_TLS_NEGOTIATION_IMPL = new String[]{"org.eclipse.jetty.alpn.ALPN", "org.eclipse.jetty.npn.NextProtoNego"};

    private ProtocolNegotiators() {
    }

    public static ChannelHandler serverTls(SSLEngine sslEngine) {
        Preconditions.checkNotNull((Object)sslEngine, (Object)"sslEngine");
        if (!ProtocolNegotiators.isOpenSsl(sslEngine.getClass()) && !ProtocolNegotiators.installJettyTlsProtocolSelection(sslEngine, (SettableFuture<Void>)SettableFuture.create(), true)) {
            throw new IllegalStateException("NPN/ALPN extensions not installed");
        }
        return new SslHandler(sslEngine, false);
    }

    public static ProtocolNegotiator tls(final SslContext sslContext, final InetSocketAddress inetAddress) {
        Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
        Preconditions.checkNotNull((Object)inetAddress, (Object)"inetAddress");
        ChannelHandlerAdapter sslBootstrapHandler = new ChannelHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                SSLEngine sslEngine = sslContext.newEngine(ctx.alloc(), inetAddress.getHostName(), inetAddress.getPort());
                SSLParameters sslParams = new SSLParameters();
                sslParams.setEndpointIdentificationAlgorithm("HTTPS");
                sslEngine.setSSLParameters(sslParams);
                final SettableFuture completeFuture = SettableFuture.create();
                if (ProtocolNegotiators.isOpenSsl(sslContext.getClass())) {
                    completeFuture.set(null);
                } else if (!ProtocolNegotiators.installJettyTlsProtocolSelection(sslEngine, (SettableFuture<Void>)completeFuture, false)) {
                    throw new IllegalStateException("NPN/ALPN extensions not installed");
                }
                SslHandler sslHandler = new SslHandler(sslEngine, false);
                sslHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(){

                    public void operationComplete(Future<? super Channel> future) throws Exception {
                        if (future.isSuccess()) {
                            completeFuture.get();
                        } else {
                            future.get();
                        }
                    }
                });
                ctx.pipeline().replace((ChannelHandler)this, "sslHandler", (ChannelHandler)sslHandler);
            }
        };
        return new ProtocolNegotiator((ChannelHandler)sslBootstrapHandler){
            final /* synthetic */ ChannelHandler val$sslBootstrapHandler;
            {
                this.val$sslBootstrapHandler = channelHandler;
            }

            @Override
            public ProtocolNegotiator.Handler newHandler(Http2ConnectionHandler handler) {
                return new BufferUntilTlsNegotiatedHandler(new ChannelHandler[]{this.val$sslBootstrapHandler, handler});
            }
        };
    }

    public static ProtocolNegotiator plaintextUpgrade() {
        return new ProtocolNegotiator(){

            @Override
            public ProtocolNegotiator.Handler newHandler(Http2ConnectionHandler handler) {
                Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec(handler);
                HttpClientCodec httpClientCodec = new HttpClientCodec();
                HttpClientUpgradeHandler upgrader = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)httpClientCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1000);
                return new BufferingHttp2UpgradeHandler(new ChannelHandler[]{upgrader});
            }
        };
    }

    public static ProtocolNegotiator plaintext() {
        return new ProtocolNegotiator(){

            @Override
            public ProtocolNegotiator.Handler newHandler(Http2ConnectionHandler handler) {
                return new BufferUntilChannelActiveHandler(new ChannelHandler[]{handler});
            }
        };
    }

    private static boolean isOpenSsl(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase().contains("openssl");
    }

    private static boolean installJettyTlsProtocolSelection(final SSLEngine engine, final SettableFuture<Void> protocolNegotiated, boolean server) {
        for (String protocolNegoClassName : JETTY_TLS_NEGOTIATION_IMPL) {
            try {
                Class<?> negoClass;
                try {
                    negoClass = Class.forName(protocolNegoClassName, true, null);
                }
                catch (ClassNotFoundException ignored) {
                    log.warning("Jetty extension " + protocolNegoClassName + " not found");
                    continue;
                }
                Class<?> providerClass = Class.forName(protocolNegoClassName + "$Provider", true, null);
                Class<?> clientProviderClass = Class.forName(protocolNegoClassName + "$ClientProvider", true, null);
                Class<?> serverProviderClass = Class.forName(protocolNegoClassName + "$ServerProvider", true, null);
                Method putMethod = negoClass.getMethod("put", SSLEngine.class, providerClass);
                final Method removeMethod = negoClass.getMethod("remove", SSLEngine.class);
                putMethod.invoke(null, engine, Proxy.newProxyInstance(null, new Class[]{server ? serverProviderClass : clientProviderClass}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        String methodName = method.getName();
                        if ("supports".equals(methodName)) {
                            return true;
                        }
                        if ("unsupported".equals(methodName)) {
                            removeMethod.invoke(null, engine);
                            protocolNegotiated.setException((Throwable)new RuntimeException("Endpoint does not support any of " + SUPPORTED_PROTOCOLS + " in ALPN/NPN negotiation"));
                            return null;
                        }
                        if ("protocols".equals(methodName)) {
                            return SUPPORTED_PROTOCOLS;
                        }
                        if ("selected".equals(methodName) || "protocolSelected".equals(methodName)) {
                            removeMethod.invoke(null, engine);
                            String protocol = (String)args[0];
                            if (!SUPPORTED_PROTOCOLS.contains(protocol)) {
                                RuntimeException e = new RuntimeException("Unsupported protocol selected via ALPN/NPN: " + protocol);
                                protocolNegotiated.setException((Throwable)e);
                                if ("selected".equals(methodName)) {
                                    throw e;
                                }
                                return null;
                            }
                            protocolNegotiated.set(null);
                            return null;
                        }
                        if ("select".equals(methodName) || "selectProtocol".equals(methodName)) {
                            removeMethod.invoke(null, engine);
                            List names = (List)args[0];
                            for (String name : names) {
                                if (!SUPPORTED_PROTOCOLS.contains(name)) continue;
                                protocolNegotiated.set(null);
                                return name;
                            }
                            RuntimeException e = new RuntimeException("Protocol not available via ALPN/NPN: " + names);
                            protocolNegotiated.setException((Throwable)e);
                            if ("select".equals(methodName)) {
                                throw e;
                            }
                            return null;
                        }
                        throw new IllegalStateException("Unknown method " + methodName);
                    }
                }));
                return true;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to initialize protocol negotation for " + protocolNegoClassName, e);
            }
        }
        return false;
    }

    private static class BufferingHttp2UpgradeHandler
    extends AbstractBufferingHandler
    implements ProtocolNegotiator.Handler {
        BufferingHttp2UpgradeHandler(ChannelHandler ... handlers) {
            super(handlers);
        }

        @Override
        public ByteString scheme() {
            return Utils.HTTP;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            DefaultHttpRequest upgradeTrigger = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
            ctx.writeAndFlush((Object)upgradeTrigger);
            super.channelActive(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                this.writeBufferedAndRemove(ctx);
            } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
                this.failBufferedAndClose(ctx);
                ctx.pipeline().fireExceptionCaught((Throwable)new Exception("HTTP/2 upgrade rejected"));
            }
            super.userEventTriggered(ctx, evt);
        }
    }

    private static class BufferUntilChannelActiveHandler
    extends AbstractBufferingHandler
    implements ProtocolNegotiator.Handler {
        BufferUntilChannelActiveHandler(ChannelHandler ... handlers) {
            super(handlers);
        }

        @Override
        public ByteString scheme() {
            return Utils.HTTP;
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.writeBufferedAndRemove(ctx);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.writeBufferedAndRemove(ctx);
            super.channelActive(ctx);
        }
    }

    private static class BufferUntilTlsNegotiatedHandler
    extends AbstractBufferingHandler
    implements ProtocolNegotiator.Handler {
        BufferUntilTlsNegotiatedHandler(ChannelHandler ... handlers) {
            super(handlers);
        }

        @Override
        public ByteString scheme() {
            return Utils.HTTPS;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                if (handshakeEvent.isSuccess()) {
                    this.writeBufferedAndRemove(ctx);
                } else {
                    this.failBufferedAndClose(ctx);
                }
            }
            super.userEventTriggered(ctx, evt);
        }
    }

    private static abstract class AbstractBufferingHandler
    extends ChannelDuplexHandler {
        private ChannelHandler[] handlers;
        private Queue<ChannelWrite> bufferedWrites = new ArrayDeque<ChannelWrite>();
        private boolean writing;
        private boolean flushRequested;

        AbstractBufferingHandler(ChannelHandler ... handlers) {
            this.handlers = handlers;
        }

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            if (this.handlers != null) {
                ctx.pipeline().addFirst(this.handlers);
                this.handlers = null;
            }
            super.channelRegistered(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.failBufferedAndClose(ctx);
            super.channelInactive(ctx);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (this.bufferedWrites == null) {
                super.write(ctx, msg, promise);
            } else {
                this.bufferedWrites.add(new ChannelWrite(msg, promise));
            }
        }

        public void flush(ChannelHandlerContext ctx) {
            if (this.bufferedWrites == null) {
                ctx.flush();
            } else {
                this.flushRequested = true;
            }
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise future) throws Exception {
            this.failBufferedAndClose(ctx);
        }

        protected void failBufferedAndClose(ChannelHandlerContext ctx) {
            if (this.bufferedWrites != null) {
                Exception e = new Exception("Buffered write failed.");
                while (!this.bufferedWrites.isEmpty()) {
                    ChannelWrite write = this.bufferedWrites.poll();
                    write.promise.setFailure((Throwable)e);
                }
                this.bufferedWrites = null;
            }
            ctx.close();
        }

        protected void writeBufferedAndRemove(ChannelHandlerContext ctx) {
            if (!ctx.channel().isActive() || this.writing) {
                return;
            }
            this.writing = true;
            while (!this.bufferedWrites.isEmpty()) {
                ChannelWrite write = this.bufferedWrites.poll();
                ctx.write(write.msg, write.promise);
            }
            assert (this.bufferedWrites.isEmpty());
            this.bufferedWrites = null;
            if (this.flushRequested) {
                ctx.flush();
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }

        private static class ChannelWrite {
            Object msg;
            ChannelPromise promise;

            ChannelWrite(Object msg, ChannelPromise promise) {
                this.msg = msg;
                this.promise = promise;
            }
        }
    }
}

