/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import io.grpc.Marshaller;
import io.grpc.ServerCallHandler;
import java.io.InputStream;

public final class ServerMethodDefinition<RequestT, ResponseT> {
    private final String name;
    private final Marshaller<RequestT> requestMarshaller;
    private final Marshaller<ResponseT> responseMarshaller;
    private final ServerCallHandler<RequestT, ResponseT> handler;

    ServerMethodDefinition(String name, Marshaller<RequestT> requestMarshaller, Marshaller<ResponseT> responseMarshaller, ServerCallHandler<RequestT, ResponseT> handler) {
        this.name = name;
        this.requestMarshaller = requestMarshaller;
        this.responseMarshaller = responseMarshaller;
        this.handler = handler;
    }

    public static <RequestT, ResponseT> ServerMethodDefinition<RequestT, ResponseT> create(String name, Marshaller<RequestT> requestMarshaller, Marshaller<ResponseT> responseMarshaller, ServerCallHandler<RequestT, ResponseT> handler) {
        return new ServerMethodDefinition<RequestT, ResponseT>(name, requestMarshaller, responseMarshaller, handler);
    }

    public String getName() {
        return this.name;
    }

    public RequestT parseRequest(InputStream input) {
        return this.requestMarshaller.parse(input);
    }

    public InputStream streamResponse(ResponseT response) {
        return this.responseMarshaller.stream(response);
    }

    public ServerCallHandler<RequestT, ResponseT> getServerCallHandler() {
        return this.handler;
    }

    public ServerMethodDefinition<RequestT, ResponseT> withServerCallHandler(ServerCallHandler<RequestT, ResponseT> handler) {
        return new ServerMethodDefinition<RequestT, ResponseT>(this.name, this.requestMarshaller, this.responseMarshaller, handler);
    }
}

