/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.grpc.Marshaller;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.protobuf.DeferredProtoInputStream;
import java.io.InputStream;

public class ProtoUtils {
    public static <T extends MessageLite> Marshaller<T> marshaller(final Parser<T> parser) {
        return new Marshaller<T>(){

            @Override
            public InputStream stream(T value) {
                return new DeferredProtoInputStream((MessageLite)value);
            }

            @Override
            public T parse(InputStream stream) {
                try {
                    return (MessageLite)parser.parseFrom(stream);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause(ipbe).asRuntimeException();
                }
            }
        };
    }

    public static <T extends Message> Metadata.Key<T> keyForProto(final T instance) {
        return Metadata.Key.of(instance.getDescriptorForType().getFullName() + "-bin", new Metadata.BinaryMarshaller<T>(){

            @Override
            public byte[] toBytes(T value) {
                return value.toByteArray();
            }

            @Override
            public T parseBytes(byte[] serialized) {
                try {
                    return (Message)instance.getParserForType().parseFrom(serialized);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw new IllegalArgumentException(ipbe);
                }
            }
        });
    }

    private ProtoUtils() {
    }
}

