/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.transport.CompositeReadableBuffer;
import io.grpc.transport.ReadableBuffer;
import io.grpc.transport.ReadableBuffers;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MessageDeframer
implements Closeable {
    private static final int HEADER_LENGTH = 5;
    private static final int COMPRESSED_FLAG_MASK = 1;
    private static final int RESERVED_MASK = 254;
    private final Listener listener;
    private final Compression compression;
    private State state = State.HEADER;
    private int requiredLength = 5;
    private boolean compressedFlag;
    private boolean endOfStream;
    private CompositeReadableBuffer nextFrame;
    private CompositeReadableBuffer unprocessed = new CompositeReadableBuffer();
    private long pendingDeliveries;
    private boolean deliveryStalled = true;
    private boolean inDelivery = false;

    public MessageDeframer(Listener listener) {
        this(listener, Compression.NONE);
    }

    public MessageDeframer(Listener listener, Compression compression) {
        this.listener = (Listener)Preconditions.checkNotNull((Object)listener, (Object)"sink");
        this.compression = (Compression)((Object)Preconditions.checkNotNull((Object)((Object)compression), (Object)"compression"));
    }

    public void request(int numMessages) {
        Preconditions.checkArgument((numMessages > 0 ? 1 : 0) != 0, (Object)"numMessages must be > 0");
        if (this.isClosed()) {
            return;
        }
        this.pendingDeliveries += (long)numMessages;
        this.deliver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deframe(ReadableBuffer data, boolean endOfStream) {
        Preconditions.checkNotNull((Object)data, (Object)"data");
        boolean needToCloseData = true;
        try {
            this.checkNotClosed();
            Preconditions.checkState((!this.endOfStream ? 1 : 0) != 0, (Object)"Past end of stream");
            needToCloseData = false;
            this.unprocessed.addBuffer(data);
            this.endOfStream = endOfStream;
            this.deliver();
        }
        finally {
            if (needToCloseData) {
                data.close();
            }
        }
    }

    public boolean isStalled() {
        return this.deliveryStalled;
    }

    @Override
    public void close() {
        try {
            if (this.unprocessed != null) {
                this.unprocessed.close();
            }
            if (this.nextFrame != null) {
                this.nextFrame.close();
            }
        }
        finally {
            this.unprocessed = null;
            this.nextFrame = null;
        }
    }

    public boolean isClosed() {
        return this.unprocessed == null;
    }

    private void checkNotClosed() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"MessageDeframer is already closed");
    }

    private void deliver() {
        if (this.inDelivery) {
            return;
        }
        this.inDelivery = true;
        try {
            boolean stalled = false;
            block7: while (this.pendingDeliveries > 0L && this.readRequiredBytes()) {
                switch (this.state) {
                    case HEADER: {
                        this.processHeader();
                        continue block7;
                    }
                    case BODY: {
                        this.processBody();
                        --this.pendingDeliveries;
                        continue block7;
                    }
                }
                throw new AssertionError((Object)("Invalid state: " + (Object)((Object)this.state)));
            }
            boolean bl = stalled = !this.isDataAvailable();
            if (this.endOfStream) {
                if (!this.isDataAvailable()) {
                    this.listener.endOfStream();
                } else if (stalled) {
                    throw Status.INTERNAL.withDescription("Encountered end-of-stream mid-frame").asRuntimeException();
                }
            }
            boolean bl2 = !this.endOfStream;
            boolean previouslyStalled = this.deliveryStalled;
            this.deliveryStalled = stalled &= bl2;
            if (stalled && !previouslyStalled) {
                this.listener.deliveryStalled();
            }
        }
        finally {
            this.inDelivery = false;
        }
    }

    private boolean isDataAvailable() {
        return this.unprocessed.readableBytes() > 0 || this.nextFrame != null && this.nextFrame.readableBytes() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readRequiredBytes() {
        int totalBytesRead = 0;
        try {
            boolean bl;
            int missingBytes;
            if (this.nextFrame == null) {
                this.nextFrame = new CompositeReadableBuffer();
            }
            while ((missingBytes = this.requiredLength - this.nextFrame.readableBytes()) > 0) {
                if (this.unprocessed.readableBytes() == 0) {
                    bl = false;
                    return bl;
                }
                int toRead = Math.min(missingBytes, this.unprocessed.readableBytes());
                totalBytesRead += toRead;
                this.nextFrame.addBuffer(this.unprocessed.readBytes(toRead));
            }
            bl = true;
            return bl;
        }
        finally {
            if (totalBytesRead > 0) {
                this.listener.bytesRead(totalBytesRead);
            }
        }
    }

    private void processHeader() {
        int type = this.nextFrame.readUnsignedByte();
        if ((type & 0xFE) != 0) {
            throw Status.INTERNAL.withDescription("Frame header malformed: reserved bits not zero").asRuntimeException();
        }
        this.compressedFlag = (type & 1) != 0;
        this.requiredLength = this.nextFrame.readInt();
        this.state = State.BODY;
    }

    private void processBody() {
        InputStream stream = this.compressedFlag ? this.getCompressedBody() : this.getUncompressedBody();
        this.nextFrame = null;
        this.listener.messageRead(stream);
        this.state = State.HEADER;
        this.requiredLength = 5;
    }

    private InputStream getUncompressedBody() {
        return ReadableBuffers.openStream(this.nextFrame, true);
    }

    private InputStream getCompressedBody() {
        if (this.compression == Compression.NONE) {
            throw Status.INTERNAL.withDescription("Can't decode compressed frame as compression not configured.").asRuntimeException();
        }
        if (this.compression != Compression.GZIP) {
            throw new AssertionError((Object)"Unknown compression type");
        }
        try {
            return new GZIPInputStream(ReadableBuffers.openStream(this.nextFrame, true));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum State {
        HEADER,
        BODY;

    }

    public static interface Listener {
        public void bytesRead(int var1);

        public void messageRead(InputStream var1);

        public void deliveryStalled();

        public void endOfStream();
    }

    public static enum Compression {
        NONE,
        GZIP;

    }
}

