/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.grpc.EquivalentAddressGroup;
import io.grpc.Status;
import io.grpc.TransportManager;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class RoundRobinServerList<T> {
    private final TransportManager<T> tm;
    private final List<EquivalentAddressGroup> list;
    private final Iterator<EquivalentAddressGroup> cyclingIter;
    private final T requestDroppingTransport;

    private RoundRobinServerList(TransportManager<T> tm, List<EquivalentAddressGroup> list) {
        this.tm = tm;
        this.list = list;
        this.cyclingIter = Iterators.cycle(list);
        this.requestDroppingTransport = tm.createFailingTransport(Status.UNAVAILABLE.withDescription("Throttled by LB"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T getTransportForNextServer() {
        EquivalentAddressGroup currentServer;
        Iterator<EquivalentAddressGroup> iterator = this.cyclingIter;
        synchronized (iterator) {
            currentServer = this.cyclingIter.next();
        }
        if (currentServer == null) {
            return this.requestDroppingTransport;
        }
        return (T)this.tm.getTransport(currentServer);
    }

    @VisibleForTesting
    List<EquivalentAddressGroup> getList() {
        return this.list;
    }

    int size() {
        return this.list.size();
    }

    @NotThreadSafe
    static class Builder<T> {
        private final ImmutableList.Builder<EquivalentAddressGroup> listBuilder = ImmutableList.builder();
        private final TransportManager<T> tm;

        Builder(TransportManager<T> tm) {
            this.tm = tm;
        }

        void add(@Nullable InetSocketAddress addr) {
            this.listBuilder.add((Object)new EquivalentAddressGroup((SocketAddress)addr));
        }

        RoundRobinServerList<T> build() {
            return new RoundRobinServerList(this.tm, (List)this.listBuilder.build());
        }
    }
}

