/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.ResolvedServerInfo;
import io.grpc.Status;
import io.grpc.TransportManager;
import io.grpc.grpclb.InitialLoadBalanceRequest;
import io.grpc.grpclb.LoadBalanceRequest;
import io.grpc.grpclb.LoadBalanceResponse;
import io.grpc.grpclb.LoadBalancerGrpc;
import io.grpc.grpclb.Server;
import io.grpc.grpclb.ServerList;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.RoundRobinServerList;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.stub.StreamObserver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

class GrpclbLoadBalancer<T>
extends LoadBalancer<T> {
    private static final Logger logger = Logger.getLogger(GrpclbLoadBalancer.class.getName());
    private static final Status SHUTDOWN_STATUS = Status.UNAVAILABLE.augmentDescription("GrpclbLoadBalancer has shut down");
    private final Object lock = new Object();
    private final String serviceName;
    private final TransportManager<T> tm;
    @GuardedBy(value="lock")
    private TransportManager.InterimTransport<T> interimTransport;
    @GuardedBy(value="lock")
    private Status lastError;
    @GuardedBy(value="lock")
    private boolean closed;
    @GuardedBy(value="lock")
    private EquivalentAddressGroup lbAddresses;
    @GuardedBy(value="lock")
    private T lbTransport;
    @GuardedBy(value="lock")
    private T directTransport;
    @GuardedBy(value="lock")
    private StreamObserver<LoadBalanceResponse> lbResponseObserver;
    @GuardedBy(value="lock")
    private StreamObserver<LoadBalanceRequest> lbRequestWriter;
    @GuardedBy(value="lock")
    private HashMap<SocketAddress, ResolvedServerInfo> servers;
    @GuardedBy(value="lock")
    @VisibleForTesting
    private RoundRobinServerList<T> roundRobinServerList;
    private ExecutorService executor;

    GrpclbLoadBalancer(String serviceName, TransportManager<T> tm) {
        this.serviceName = serviceName;
        this.tm = tm;
        this.executor = (ExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    StreamObserver<LoadBalanceResponse> getLbResponseObserver() {
        Object object = this.lock;
        synchronized (object) {
            return this.lbResponseObserver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    RoundRobinServerList<T> getRoundRobinServerList() {
        Object object = this.lock;
        synchronized (object) {
            return this.roundRobinServerList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T pickTransport(Attributes affinity) {
        RoundRobinServerList<T> serverListCopy;
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return (T)this.tm.createFailingTransport(SHUTDOWN_STATUS);
            }
            if (this.directTransport != null) {
                return this.directTransport;
            }
            if (this.roundRobinServerList == null) {
                if (this.lastError != null) {
                    return (T)this.tm.createFailingTransport(this.lastError);
                }
                if (this.interimTransport == null) {
                    this.interimTransport = this.tm.createInterimTransport();
                }
                return (T)this.interimTransport.transport();
            }
            serverListCopy = this.roundRobinServerList;
        }
        return (T)serverListCopy.getTransportForNextServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResolvedAddresses(List<? extends List<ResolvedServerInfo>> updatedServers, Attributes config) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            ArrayList<SocketAddress> addrs = new ArrayList<SocketAddress>(updatedServers.size());
            for (List<ResolvedServerInfo> list : updatedServers) {
                for (ResolvedServerInfo serverInfo : list) {
                    addrs.add(serverInfo.getAddress());
                }
            }
            EquivalentAddressGroup newLbAddresses = new EquivalentAddressGroup(addrs);
            if (!newLbAddresses.equals((Object)this.lbAddresses)) {
                this.lbAddresses = newLbAddresses;
                this.connectToLb();
            }
        }
        this.updateRetainedTransports();
    }

    @GuardedBy(value="lock")
    private void connectToLb() {
        this.directTransport = null;
        if (this.closed) {
            return;
        }
        this.lbResponseObserver = null;
        Preconditions.checkNotNull((Object)this.lbAddresses, (Object)"lbAddresses");
        this.lbTransport = this.tm.getTransport(this.lbAddresses);
        this.startNegotiation();
    }

    @GuardedBy(value="lock")
    private void startNegotiation() {
        if (this.closed) {
            return;
        }
        Preconditions.checkState((this.lbTransport != null ? 1 : 0) != 0, (Object)"lbTransport must be available");
        logger.info("Starting LB negotiation");
        LoadBalanceRequest initRequest = LoadBalanceRequest.newBuilder().setInitialRequest(InitialLoadBalanceRequest.newBuilder().setName(this.serviceName).build()).build();
        this.lbResponseObserver = new LbResponseObserver();
        this.sendLbRequest(this.lbTransport, initRequest);
    }

    @VisibleForTesting
    @GuardedBy(value="lock")
    void sendLbRequest(T transport, LoadBalanceRequest request) {
        Channel channel = this.tm.makeChannel(transport);
        LoadBalancerGrpc.LoadBalancerStub stub = LoadBalancerGrpc.newStub(channel);
        this.lbRequestWriter = stub.balanceLoad(this.lbResponseObserver);
        this.lbRequestWriter.onNext((Object)request);
    }

    public void handleNameResolutionError(Status error) {
        this.handleError(error.augmentDescription("Name resolution failed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        TransportManager.InterimTransport<T> savedInterimTransport;
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.lbRequestWriter != null) {
                this.lbRequestWriter.onCompleted();
            }
            savedInterimTransport = this.interimTransport;
            this.interimTransport = null;
            this.executor = (ExecutorService)SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR, (Object)this.executor);
        }
        if (savedInterimTransport != null) {
            savedInterimTransport.closeWithError(SHUTDOWN_STATUS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTransportShutdown(EquivalentAddressGroup addressGroup, Status status) {
        this.handleError(status.augmentDescription("Transport to LB server closed"));
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (addressGroup.equals((Object)this.lbAddresses)) {
                this.connectToLb();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(Status error) {
        TransportManager.InterimTransport<T> savedInterimTransport;
        Object object = this.lock;
        synchronized (object) {
            savedInterimTransport = this.interimTransport;
            this.interimTransport = null;
            this.lastError = error;
        }
        if (savedInterimTransport != null) {
            savedInterimTransport.closeWithError(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRetainedTransports() {
        HashSet<EquivalentAddressGroup> addresses = new HashSet<EquivalentAddressGroup>();
        Object object = this.lock;
        synchronized (object) {
            if (this.lbAddresses != null) {
                addresses.add(this.lbAddresses);
            }
            if (this.servers != null) {
                for (SocketAddress addr : this.servers.keySet()) {
                    addresses.add(new EquivalentAddressGroup(addr));
                }
            }
        }
        this.tm.updateRetainedTransports(addresses);
    }

    private class LbResponseObserver
    implements StreamObserver<LoadBalanceResponse> {
        private LbResponseObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(LoadBalanceResponse response) {
            TransportManager.InterimTransport savedInterimTransport;
            logger.info("Got a LB response: " + response);
            RoundRobinServerList.Builder listBuilder = new RoundRobinServerList.Builder(GrpclbLoadBalancer.this.tm);
            ServerList serverList = response.getServerList();
            HashMap<InetSocketAddress, ResolvedServerInfo> newServerMap = new HashMap<InetSocketAddress, ResolvedServerInfo>();
            for (Server server : serverList.getServersList()) {
                if (server.getDropRequest()) {
                    listBuilder.add(null);
                    continue;
                }
                try {
                    InetSocketAddress address = new InetSocketAddress(InetAddress.getByAddress(server.getIpAddress().toByteArray()), server.getPort());
                    listBuilder.add((SocketAddress)address);
                    if (newServerMap.containsKey(address)) continue;
                    newServerMap.put(address, new ResolvedServerInfo((SocketAddress)address, Attributes.EMPTY));
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
            final RoundRobinServerList newRoundRobinServerList = listBuilder.build();
            if (newRoundRobinServerList.size() == 0) {
                return;
            }
            Object object = GrpclbLoadBalancer.this.lock;
            synchronized (object) {
                if (GrpclbLoadBalancer.this.lbResponseObserver != this) {
                    return;
                }
                GrpclbLoadBalancer.this.roundRobinServerList = newRoundRobinServerList;
                GrpclbLoadBalancer.this.servers = newServerMap;
                savedInterimTransport = GrpclbLoadBalancer.this.interimTransport;
                GrpclbLoadBalancer.this.interimTransport = null;
            }
            GrpclbLoadBalancer.this.updateRetainedTransports();
            if (savedInterimTransport != null) {
                savedInterimTransport.closeWithRealTransports(new Supplier<T>(){

                    public T get() {
                        return newRoundRobinServerList.getTransportForNextServer();
                    }
                });
            }
        }

        public void onError(Throwable error) {
            this.onStreamClosed(Status.fromThrowable((Throwable)error).augmentDescription("Stream to GRPCLB LoadBalancer had an error"));
        }

        public void onCompleted() {
            this.onStreamClosed(Status.UNAVAILABLE.augmentDescription("Stream to GRPCLB LoadBalancer was closed"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onStreamClosed(Status status) {
            if (status.getCode() == Status.Code.UNIMPLEMENTED) {
                TransportManager.InterimTransport savedInterimTransport;
                Object transport;
                Object object = GrpclbLoadBalancer.this.lock;
                synchronized (object) {
                    if (GrpclbLoadBalancer.this.lbResponseObserver != this) {
                        return;
                    }
                    transport = GrpclbLoadBalancer.this.lbTransport;
                    GrpclbLoadBalancer.this.directTransport = transport;
                    savedInterimTransport = GrpclbLoadBalancer.this.interimTransport;
                    GrpclbLoadBalancer.this.interimTransport = null;
                }
                if (savedInterimTransport != null) {
                    savedInterimTransport.closeWithRealTransports(Suppliers.ofInstance((Object)transport));
                }
            } else {
                GrpclbLoadBalancer.this.handleError(status);
                Object object = GrpclbLoadBalancer.this.lock;
                synchronized (object) {
                    if (GrpclbLoadBalancer.this.lbResponseObserver != this) {
                        return;
                    }
                    GrpclbLoadBalancer.this.startNegotiation();
                }
            }
        }
    }
}

