/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.grpclb.BackendAddressGroup;
import io.grpc.grpclb.ClientStats;
import io.grpc.grpclb.GrpclbClientLoadRecorder;
import io.grpc.grpclb.GrpclbConstants;
import io.grpc.grpclb.InitialLoadBalanceRequest;
import io.grpc.grpclb.InitialLoadBalanceResponse;
import io.grpc.grpclb.LbAddressGroup;
import io.grpc.grpclb.LoadBalanceRequest;
import io.grpc.grpclb.LoadBalanceResponse;
import io.grpc.grpclb.LoadBalancerGrpc;
import io.grpc.grpclb.Server;
import io.grpc.grpclb.ServerList;
import io.grpc.grpclb.SubchannelPool;
import io.grpc.internal.LogId;
import io.grpc.internal.TimeProvider;
import io.grpc.stub.StreamObserver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class GrpclbState {
    private static final Logger logger = Logger.getLogger(GrpclbState.class.getName());
    static final long FALLBACK_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    @VisibleForTesting
    static final LoadBalancer.PickResult DROP_PICK_RESULT = LoadBalancer.PickResult.withDrop((Status)Status.UNAVAILABLE.withDescription("Dropped as requested by balancer"));
    @VisibleForTesting
    static final RoundRobinEntry BUFFER_ENTRY = new RoundRobinEntry(){

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            return LoadBalancer.PickResult.withNoResult();
        }

        public String toString() {
            return "BUFFER_ENTRY";
        }
    };
    private final LogId logId;
    private final String serviceName;
    private final LoadBalancer.Helper helper;
    private final SubchannelPool subchannelPool;
    private final TimeProvider time;
    private final ScheduledExecutorService timerService;
    private static final Attributes.Key<AtomicReference<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.create((String)"io.grpc.grpclb.GrpclbLoadBalancer.stateInfo");
    @Nullable
    private FallbackModeTask fallbackTimer;
    private List<EquivalentAddressGroup> fallbackBackendList = Collections.emptyList();
    private boolean usingFallbackBackends;
    private boolean balancerWorking;
    @Nullable
    private ManagedChannel lbCommChannel;
    @Nullable
    private LbStream lbStream;
    private Map<EquivalentAddressGroup, LoadBalancer.Subchannel> subchannels = Collections.emptyMap();
    private List<DropEntry> dropList = Collections.emptyList();
    private List<BackendEntry> backendList = Collections.emptyList();
    private RoundRobinPicker currentPicker = new RoundRobinPicker(Collections.<DropEntry>emptyList(), Arrays.asList(BUFFER_ENTRY));

    GrpclbState(LoadBalancer.Helper helper, SubchannelPool subchannelPool, TimeProvider time, ScheduledExecutorService timerService, LogId logId) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.subchannelPool = (SubchannelPool)Preconditions.checkNotNull((Object)subchannelPool, (Object)"subchannelPool");
        this.time = (TimeProvider)Preconditions.checkNotNull((Object)time, (Object)"time provider");
        this.timerService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timerService, (Object)"timerService");
        this.serviceName = (String)Preconditions.checkNotNull((Object)helper.getAuthority(), (Object)"helper returns null authority");
        this.logId = (LogId)Preconditions.checkNotNull((Object)logId, (Object)"logId");
    }

    void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo newState) {
        if (newState.getState() == ConnectivityState.SHUTDOWN || !this.subchannels.values().contains(subchannel)) {
            return;
        }
        if (newState.getState() == ConnectivityState.IDLE) {
            subchannel.requestConnection();
        }
        ((AtomicReference)subchannel.getAttributes().get(STATE_INFO)).set(newState);
        this.maybeUseFallbackBackends();
        this.maybeUpdatePicker();
    }

    void handleAddresses(List<LbAddressGroup> newLbAddressGroups, List<EquivalentAddressGroup> newBackendServers) {
        if (newLbAddressGroups.isEmpty()) {
            this.propagateError(Status.UNAVAILABLE.withDescription("NameResolver returned no LB address while asking for GRPCLB"));
            return;
        }
        LbAddressGroup newLbAddressGroup = this.flattenLbAddressGroups(newLbAddressGroups);
        this.startLbComm(newLbAddressGroup);
        if (this.lbStream == null) {
            this.startLbRpc();
        }
        this.fallbackBackendList = newBackendServers;
        if (this.fallbackTimer == null) {
            logger.log(Level.FINE, "[{0}] Starting fallback timer.", new Object[]{this.logId});
            this.fallbackTimer = new FallbackModeTask();
            this.fallbackTimer.schedule();
        }
        if (this.usingFallbackBackends) {
            this.useFallbackBackends();
        }
        this.maybeUpdatePicker();
    }

    private void maybeUseFallbackBackends() {
        if (this.balancerWorking) {
            return;
        }
        if (this.usingFallbackBackends) {
            return;
        }
        if (this.fallbackTimer != null && !this.fallbackTimer.discarded) {
            return;
        }
        int numReadySubchannels = 0;
        for (LoadBalancer.Subchannel subchannel : this.subchannels.values()) {
            if (((ConnectivityStateInfo)((AtomicReference)subchannel.getAttributes().get(STATE_INFO)).get()).getState() != ConnectivityState.READY) continue;
            ++numReadySubchannels;
        }
        if (numReadySubchannels > 0) {
            return;
        }
        this.useFallbackBackends();
    }

    private void useFallbackBackends() {
        this.usingFallbackBackends = true;
        logger.log(Level.INFO, "[{0}] Using fallback: {1}", new Object[]{this.logId, this.fallbackBackendList});
        ArrayList<DropEntry> newDropList = new ArrayList<DropEntry>();
        ArrayList<BackendAddressGroup> newBackendAddrList = new ArrayList<BackendAddressGroup>();
        for (EquivalentAddressGroup eag : this.fallbackBackendList) {
            newDropList.add(null);
            newBackendAddrList.add(new BackendAddressGroup(eag, null));
        }
        this.useRoundRobinLists(newDropList, newBackendAddrList, null);
    }

    private void shutdownLbComm() {
        if (this.lbCommChannel != null) {
            this.lbCommChannel.shutdown();
            this.lbCommChannel = null;
        }
        this.shutdownLbRpc();
    }

    private void shutdownLbRpc() {
        if (this.lbStream != null) {
            this.lbStream.close(null);
        }
    }

    private void startLbComm(LbAddressGroup lbAddressGroup) {
        Preconditions.checkNotNull((Object)lbAddressGroup, (Object)"lbAddressGroup");
        if (this.lbCommChannel == null) {
            this.lbCommChannel = this.helper.createOobChannel(lbAddressGroup.getAddresses(), lbAddressGroup.getAuthority());
        } else if (lbAddressGroup.getAuthority().equals(this.lbCommChannel.authority())) {
            this.helper.updateOobChannelAddresses(this.lbCommChannel, lbAddressGroup.getAddresses());
        } else {
            this.shutdownLbComm();
            this.lbCommChannel = this.helper.createOobChannel(lbAddressGroup.getAddresses(), lbAddressGroup.getAuthority());
        }
    }

    private void startLbRpc() {
        Preconditions.checkState((this.lbStream == null ? 1 : 0) != 0, (Object)"previous lbStream has not been cleared yet");
        LoadBalancerGrpc.LoadBalancerStub stub = LoadBalancerGrpc.newStub((Channel)this.lbCommChannel);
        this.lbStream = new LbStream(stub);
        this.lbStream.start();
        LoadBalanceRequest initRequest = LoadBalanceRequest.newBuilder().setInitialRequest(InitialLoadBalanceRequest.newBuilder().setName(this.serviceName).build()).build();
        try {
            this.lbStream.lbRequestWriter.onNext((Object)initRequest);
        }
        catch (Exception e) {
            this.lbStream.close(e);
        }
    }

    private void cancelFallbackTimer() {
        if (this.fallbackTimer != null) {
            this.fallbackTimer.cancel();
        }
    }

    void shutdown() {
        this.shutdownLbComm();
        for (LoadBalancer.Subchannel subchannel : this.subchannels.values()) {
            this.subchannelPool.returnSubchannel(subchannel);
        }
        this.subchannels = Collections.emptyMap();
        this.subchannelPool.clear();
        this.cancelFallbackTimer();
    }

    void propagateError(Status status) {
        logger.log(Level.FINE, "[{0}] Had an error: {1}; dropList={2}; backendList={3}", new Object[]{this.logId, status, this.dropList, this.backendList});
        if (this.backendList.isEmpty()) {
            this.maybeUpdatePicker(ConnectivityState.TRANSIENT_FAILURE, new RoundRobinPicker(this.dropList, Arrays.asList(new ErrorEntry(status))));
        }
    }

    @Nullable
    @VisibleForTesting
    GrpclbClientLoadRecorder getLoadRecorder() {
        if (this.lbStream == null) {
            return null;
        }
        return this.lbStream.loadRecorder;
    }

    private void useRoundRobinLists(List<DropEntry> newDropList, List<BackendAddressGroup> newBackendAddrList, @Nullable GrpclbClientLoadRecorder loadRecorder) {
        EquivalentAddressGroup eag;
        HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel> newSubchannelMap = new HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel>();
        ArrayList<BackendEntry> newBackendList = new ArrayList<BackendEntry>();
        for (BackendAddressGroup backendAddressGroup : newBackendAddrList) {
            eag = backendAddressGroup.getAddresses();
            LoadBalancer.Subchannel subchannel = (LoadBalancer.Subchannel)newSubchannelMap.get(eag);
            if (subchannel == null) {
                subchannel = this.subchannels.get(eag);
                if (subchannel == null) {
                    Attributes subchannelAttrs = Attributes.newBuilder().set(STATE_INFO, new AtomicReference<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError((ConnectivityState)ConnectivityState.IDLE))).build();
                    subchannel = this.subchannelPool.takeOrCreateSubchannel(eag, subchannelAttrs);
                    subchannel.requestConnection();
                }
                newSubchannelMap.put(eag, subchannel);
            }
            BackendEntry entry = backendAddressGroup.getToken() == null ? new BackendEntry(subchannel) : new BackendEntry(subchannel, loadRecorder, backendAddressGroup.getToken());
            newBackendList.add(entry);
        }
        for (Map.Entry entry : this.subchannels.entrySet()) {
            eag = (EquivalentAddressGroup)entry.getKey();
            if (newSubchannelMap.containsKey(eag)) continue;
            this.subchannelPool.returnSubchannel((LoadBalancer.Subchannel)entry.getValue());
        }
        this.subchannels = Collections.unmodifiableMap(newSubchannelMap);
        this.dropList = Collections.unmodifiableList(newDropList);
        this.backendList = Collections.unmodifiableList(newBackendList);
    }

    private void maybeUpdatePicker() {
        ConnectivityState state;
        ArrayList<RoundRobinEntry> pickList = new ArrayList<RoundRobinEntry>(this.backendList.size());
        Status error = null;
        boolean hasIdle = false;
        for (BackendEntry entry : this.backendList) {
            LoadBalancer.Subchannel subchannel = entry.result.getSubchannel();
            Attributes attrs = subchannel.getAttributes();
            ConnectivityStateInfo stateInfo = (ConnectivityStateInfo)((AtomicReference)attrs.get(STATE_INFO)).get();
            if (stateInfo.getState() == ConnectivityState.READY) {
                pickList.add(entry);
                continue;
            }
            if (stateInfo.getState() == ConnectivityState.TRANSIENT_FAILURE) {
                error = stateInfo.getStatus();
                continue;
            }
            if (stateInfo.getState() != ConnectivityState.IDLE) continue;
            hasIdle = true;
        }
        if (pickList.isEmpty()) {
            if (error != null && !hasIdle) {
                logger.log(Level.FINE, "[{0}] No ready Subchannel. Using error: {1}", new Object[]{this.logId, error});
                pickList.add(new ErrorEntry(error));
                state = ConnectivityState.TRANSIENT_FAILURE;
            } else {
                logger.log(Level.FINE, "[{0}] No ready Subchannel and still connecting", this.logId);
                pickList.add(BUFFER_ENTRY);
                state = ConnectivityState.CONNECTING;
            }
        } else {
            logger.log(Level.FINE, "[{0}] Using drop list {1} and pick list {2}", new Object[]{this.logId, this.dropList, pickList});
            state = ConnectivityState.READY;
        }
        this.maybeUpdatePicker(state, new RoundRobinPicker(this.dropList, pickList));
    }

    private void maybeUpdatePicker(ConnectivityState state, RoundRobinPicker picker) {
        if (picker.dropList.equals(this.currentPicker.dropList) && picker.pickList.equals(this.currentPicker.pickList)) {
            return;
        }
        this.currentPicker = picker;
        this.helper.updateBalancingState(state, (LoadBalancer.SubchannelPicker)picker);
    }

    private LbAddressGroup flattenLbAddressGroups(List<LbAddressGroup> groupList) {
        assert (!groupList.isEmpty());
        ArrayList<EquivalentAddressGroup> eags = new ArrayList<EquivalentAddressGroup>(groupList.size());
        String authority = groupList.get(0).getAuthority();
        for (LbAddressGroup group : groupList) {
            if (!authority.equals(group.getAuthority())) {
                logger.log(Level.WARNING, "[{0}] Multiple authorities found for LB. Skipping addresses for {0} in preference to {1}", new Object[]{this.logId, group.getAuthority(), authority});
                continue;
            }
            eags.add(group.getAddresses());
        }
        return new LbAddressGroup(GrpclbState.flattenEquivalentAddressGroup(eags), authority);
    }

    private static EquivalentAddressGroup flattenEquivalentAddressGroup(List<EquivalentAddressGroup> groupList) {
        ArrayList addrs = new ArrayList();
        for (EquivalentAddressGroup group : groupList) {
            addrs.addAll(group.getAddresses());
        }
        return new EquivalentAddressGroup(addrs);
    }

    @VisibleForTesting
    static final class RoundRobinPicker
    extends LoadBalancer.SubchannelPicker {
        @VisibleForTesting
        final List<DropEntry> dropList;
        private int dropIndex;
        @VisibleForTesting
        final List<? extends RoundRobinEntry> pickList;
        private int pickIndex;

        RoundRobinPicker(List<DropEntry> dropList, List<? extends RoundRobinEntry> pickList) {
            this.dropList = (List)Preconditions.checkNotNull(dropList, (Object)"dropList");
            this.pickList = (List)Preconditions.checkNotNull(pickList, (Object)"pickList");
            Preconditions.checkArgument((!pickList.isEmpty() ? 1 : 0) != 0, (Object)"pickList is empty");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            List<? extends RoundRobinEntry> list = this.pickList;
            synchronized (list) {
                if (!this.dropList.isEmpty()) {
                    DropEntry drop = this.dropList.get(this.dropIndex);
                    ++this.dropIndex;
                    if (this.dropIndex == this.dropList.size()) {
                        this.dropIndex = 0;
                    }
                    if (drop != null) {
                        return drop.picked();
                    }
                }
                RoundRobinEntry pick = this.pickList.get(this.pickIndex);
                ++this.pickIndex;
                if (this.pickIndex == this.pickList.size()) {
                    this.pickIndex = 0;
                }
                return pick.picked(args.getHeaders());
            }
        }
    }

    @VisibleForTesting
    static final class ErrorEntry
    implements RoundRobinEntry {
        final LoadBalancer.PickResult result;

        ErrorEntry(Status status) {
            this.result = LoadBalancer.PickResult.withError((Status)status);
        }

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            return this.result;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.result});
        }

        public boolean equals(Object other) {
            if (!(other instanceof ErrorEntry)) {
                return false;
            }
            return Objects.equal((Object)this.result, (Object)((ErrorEntry)other).result);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("result", (Object)this.result).toString();
        }
    }

    @VisibleForTesting
    static final class BackendEntry
    implements RoundRobinEntry {
        @VisibleForTesting
        final LoadBalancer.PickResult result;
        @Nullable
        private final GrpclbClientLoadRecorder loadRecorder;
        @Nullable
        private final String token;

        BackendEntry(LoadBalancer.Subchannel subchannel, GrpclbClientLoadRecorder loadRecorder, String token) {
            this.result = LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel, (ClientStreamTracer.Factory)loadRecorder);
            this.loadRecorder = (GrpclbClientLoadRecorder)((Object)Preconditions.checkNotNull((Object)((Object)loadRecorder), (Object)"loadRecorder"));
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
        }

        BackendEntry(LoadBalancer.Subchannel subchannel) {
            this.result = LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel);
            this.loadRecorder = null;
            this.token = null;
        }

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            headers.discardAll(GrpclbConstants.TOKEN_METADATA_KEY);
            if (this.token != null) {
                headers.put(GrpclbConstants.TOKEN_METADATA_KEY, (Object)this.token);
            }
            return this.result;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("result", (Object)this.result).add("loadRecorder", (Object)this.loadRecorder).add("token", (Object)this.token).toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.loadRecorder, this.result, this.token});
        }

        public boolean equals(Object other) {
            if (!(other instanceof BackendEntry)) {
                return false;
            }
            BackendEntry that = (BackendEntry)other;
            return Objects.equal((Object)this.result, (Object)that.result) && Objects.equal((Object)this.token, (Object)that.token) && Objects.equal((Object)((Object)this.loadRecorder), (Object)((Object)that.loadRecorder));
        }
    }

    private static interface RoundRobinEntry {
        public LoadBalancer.PickResult picked(Metadata var1);
    }

    @VisibleForTesting
    static final class DropEntry {
        private final GrpclbClientLoadRecorder loadRecorder;
        private final String token;

        DropEntry(GrpclbClientLoadRecorder loadRecorder, String token) {
            this.loadRecorder = (GrpclbClientLoadRecorder)((Object)Preconditions.checkNotNull((Object)((Object)loadRecorder), (Object)"loadRecorder"));
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
        }

        LoadBalancer.PickResult picked() {
            this.loadRecorder.recordDroppedRequest(this.token);
            return DROP_PICK_RESULT;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("loadRecorder", (Object)this.loadRecorder).add("token", (Object)this.token).toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.loadRecorder, this.token});
        }

        public boolean equals(Object other) {
            if (!(other instanceof DropEntry)) {
                return false;
            }
            DropEntry that = (DropEntry)other;
            return Objects.equal((Object)((Object)this.loadRecorder), (Object)((Object)that.loadRecorder)) && Objects.equal((Object)this.token, (Object)that.token);
        }
    }

    private class LbStream
    implements StreamObserver<LoadBalanceResponse> {
        final GrpclbClientLoadRecorder loadRecorder;
        final LoadBalancerGrpc.LoadBalancerStub stub;
        StreamObserver<LoadBalanceRequest> lbRequestWriter;
        boolean initialResponseReceived;
        boolean closed;
        long loadReportIntervalMillis = -1L;
        ScheduledFuture<?> loadReportFuture;

        LbStream(LoadBalancerGrpc.LoadBalancerStub stub) {
            this.stub = (LoadBalancerGrpc.LoadBalancerStub)((Object)Preconditions.checkNotNull((Object)((Object)stub), (Object)"stub"));
            this.loadRecorder = new GrpclbClientLoadRecorder(GrpclbState.this.time);
        }

        void start() {
            this.lbRequestWriter = ((LoadBalancerGrpc.LoadBalancerStub)this.stub.withWaitForReady()).balanceLoad(this);
        }

        public void onNext(final LoadBalanceResponse response) {
            GrpclbState.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleResponse(response);
                }
            });
        }

        public void onError(final Throwable error) {
            GrpclbState.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleStreamClosed(Status.fromThrowable((Throwable)error).augmentDescription("Stream to GRPCLB LoadBalancer had an error"));
                }
            });
        }

        public void onCompleted() {
            GrpclbState.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleStreamClosed(Status.UNAVAILABLE.withDescription("Stream to GRPCLB LoadBalancer was closed"));
                }
            });
        }

        private void sendLoadReport() {
            if (this.closed) {
                return;
            }
            ClientStats stats = this.loadRecorder.generateLoadReport();
            try {
                this.lbRequestWriter.onNext((Object)LoadBalanceRequest.newBuilder().setClientStats(stats).build());
                this.scheduleNextLoadReport();
            }
            catch (Exception e) {
                this.close(e);
            }
        }

        private void scheduleNextLoadReport() {
            if (this.loadReportIntervalMillis > 0L) {
                this.loadReportFuture = GrpclbState.this.timerService.schedule(new LoadReportingTask(this), this.loadReportIntervalMillis, TimeUnit.MILLISECONDS);
            }
        }

        private void handleResponse(LoadBalanceResponse response) {
            if (this.closed) {
                return;
            }
            logger.log(Level.FINE, "[{0}] Got an LB response: {1}", new Object[]{GrpclbState.this.logId, response});
            LoadBalanceResponse.LoadBalanceResponseTypeCase typeCase = response.getLoadBalanceResponseTypeCase();
            if (!this.initialResponseReceived) {
                if (typeCase != LoadBalanceResponse.LoadBalanceResponseTypeCase.INITIAL_RESPONSE) {
                    logger.log(Level.WARNING, "[{0}] : Did not receive response with type initial response: {1}", new Object[]{GrpclbState.this.logId, response});
                    return;
                }
                this.initialResponseReceived = true;
                InitialLoadBalanceResponse initialResponse = response.getInitialResponse();
                this.loadReportIntervalMillis = Durations.toMillis((Duration)initialResponse.getClientStatsReportInterval());
                this.scheduleNextLoadReport();
                return;
            }
            if (typeCase != LoadBalanceResponse.LoadBalanceResponseTypeCase.SERVER_LIST) {
                logger.log(Level.WARNING, "[{0}] : Ignoring unexpected response type: {1}", new Object[]{GrpclbState.this.logId, response});
                return;
            }
            GrpclbState.this.balancerWorking = true;
            ServerList serverList = response.getServerList();
            ArrayList<DropEntry> newDropList = new ArrayList<DropEntry>();
            ArrayList<BackendAddressGroup> newBackendAddrList = new ArrayList<BackendAddressGroup>();
            for (Server server : serverList.getServersList()) {
                InetSocketAddress address;
                String token = server.getLoadBalanceToken();
                if (server.getDrop()) {
                    newDropList.add(new DropEntry(this.loadRecorder, token));
                    continue;
                }
                newDropList.add(null);
                try {
                    address = new InetSocketAddress(InetAddress.getByAddress(server.getIpAddress().toByteArray()), server.getPort());
                }
                catch (UnknownHostException e) {
                    GrpclbState.this.propagateError(Status.UNAVAILABLE.withDescription("Host for server not found: " + server).withCause((Throwable)e));
                    continue;
                }
                EquivalentAddressGroup eag = new EquivalentAddressGroup((SocketAddress)address);
                newBackendAddrList.add(new BackendAddressGroup(eag, token));
            }
            GrpclbState.this.usingFallbackBackends = false;
            GrpclbState.this.cancelFallbackTimer();
            GrpclbState.this.useRoundRobinLists(newDropList, newBackendAddrList, this.loadRecorder);
            GrpclbState.this.maybeUpdatePicker();
        }

        private void handleStreamClosed(Status error) {
            Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"unexpected OK status");
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            GrpclbState.this.propagateError(error);
            GrpclbState.this.balancerWorking = false;
            GrpclbState.this.maybeUseFallbackBackends();
            GrpclbState.this.maybeUpdatePicker();
            GrpclbState.this.startLbRpc();
        }

        void close(@Nullable Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            try {
                if (error == null) {
                    this.lbRequestWriter.onCompleted();
                } else {
                    this.lbRequestWriter.onError((Throwable)error);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void cleanUp() {
            if (this.loadReportFuture != null) {
                this.loadReportFuture.cancel(false);
                this.loadReportFuture = null;
            }
            if (GrpclbState.this.lbStream == this) {
                GrpclbState.this.lbStream = null;
            }
        }
    }

    @VisibleForTesting
    class LoadReportingTask
    implements Runnable {
        private final LbStream stream;

        LoadReportingTask(LbStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            GrpclbState.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    ((LoadReportingTask)LoadReportingTask.this).stream.loadReportFuture = null;
                    LoadReportingTask.this.stream.sendLoadReport();
                }
            });
        }
    }

    @VisibleForTesting
    class FallbackModeTask
    implements Runnable {
        private ScheduledFuture<?> scheduledFuture;
        private boolean discarded;

        FallbackModeTask() {
        }

        @Override
        public void run() {
            GrpclbState.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    Preconditions.checkState((GrpclbState.this.fallbackTimer == FallbackModeTask.this ? 1 : 0) != 0, (Object)"fallback timer mismatch");
                    FallbackModeTask.this.discarded = true;
                    GrpclbState.this.maybeUseFallbackBackends();
                    GrpclbState.this.maybeUpdatePicker();
                }
            });
        }

        void cancel() {
            this.discarded = true;
            this.scheduledFuture.cancel(false);
        }

        void schedule() {
            Preconditions.checkState((this.scheduledFuture == null ? 1 : 0) != 0, (Object)"FallbackModeTask already scheduled");
            this.scheduledFuture = GrpclbState.this.timerService.schedule(this, FALLBACK_TIMEOUT_MS, TimeUnit.MILLISECONDS);
        }
    }
}

