/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.base.Stopwatch;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.grpclb.CachedSubchannelPool;
import io.grpc.grpclb.GrpclbLoadBalancer;
import io.grpc.grpclb.GrpclbState;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.internal.TimeProvider;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public final class GrpclbLoadBalancerProvider
extends LoadBalancerProvider {
    private static final GrpclbState.Mode DEFAULT_MODE = GrpclbState.Mode.ROUND_ROBIN;

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "grpclb";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new GrpclbLoadBalancer(helper, new CachedSubchannelPool(), TimeProvider.SYSTEM_TIME_PROVIDER, Stopwatch.createUnstarted(), (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider());
    }

    public NameResolver.Helper.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingConfigPolicy) {
        try {
            return this.parseLoadBalancingConfigPolicyInternal(rawLoadBalancingConfigPolicy);
        }
        catch (RuntimeException e) {
            return NameResolver.Helper.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("can't parse config: " + e.getMessage()).withCause((Throwable)e));
        }
    }

    NameResolver.Helper.ConfigOrError parseLoadBalancingConfigPolicyInternal(Map<String, ?> rawLoadBalancingPolicyConfig) {
        if (rawLoadBalancingPolicyConfig == null) {
            return NameResolver.Helper.ConfigOrError.fromConfig((Object)((Object)DEFAULT_MODE));
        }
        List<?> rawChildPolicies = GrpclbLoadBalancerProvider.getList(rawLoadBalancingPolicyConfig, "childPolicy");
        if (rawChildPolicies == null) {
            return NameResolver.Helper.ConfigOrError.fromConfig((Object)((Object)DEFAULT_MODE));
        }
        List childPolicies = ServiceConfigUtil.unwrapLoadBalancingConfigList(GrpclbLoadBalancerProvider.checkObjectList(rawChildPolicies));
        for (ServiceConfigUtil.LbConfig childPolicy : childPolicies) {
            String childPolicyName;
            switch (childPolicyName = childPolicy.getPolicyName()) {
                case "round_robin": {
                    return NameResolver.Helper.ConfigOrError.fromConfig((Object)((Object)GrpclbState.Mode.ROUND_ROBIN));
                }
                case "pick_first": {
                    return NameResolver.Helper.ConfigOrError.fromConfig((Object)((Object)GrpclbState.Mode.PICK_FIRST));
                }
            }
        }
        return NameResolver.Helper.ConfigOrError.fromConfig((Object)((Object)DEFAULT_MODE));
    }

    @Nullable
    private static List<?> getList(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof List)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in %s is not List", value, key, obj));
        }
        return (List)value;
    }

    private static List<Map<String, ?>> checkObjectList(List<?> rawList) {
        for (int i = 0; i < rawList.size(); ++i) {
            if (rawList.get(i) instanceof Map) continue;
            throw new ClassCastException(String.format("value %s for idx %d in %s is not object", rawList.get(i), i, rawList));
        }
        return rawList;
    }
}

