/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.grpclb.GrpclbConstants;
import io.grpc.grpclb.InitialLoadBalanceRequest;
import io.grpc.grpclb.LbAddressGroup;
import io.grpc.grpclb.LoadBalanceRequest;
import io.grpc.grpclb.LoadBalanceResponse;
import io.grpc.grpclb.LoadBalancerGrpc;
import io.grpc.grpclb.Server;
import io.grpc.grpclb.ServerList;
import io.grpc.internal.LogId;
import io.grpc.internal.WithLogId;
import io.grpc.stub.StreamObserver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class GrpclbLoadBalancer
extends LoadBalancer
implements WithLogId {
    private static final Logger logger = Logger.getLogger(GrpclbLoadBalancer.class.getName());
    @VisibleForTesting
    static final LoadBalancer.SubchannelPicker BUFFER_PICKER = new LoadBalancer.SubchannelPicker(){

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withNoResult();
        }
    };
    private final LogId logId = LogId.allocate((String)((Object)((Object)this)).getClass().getName());
    private final String serviceName;
    private final LoadBalancer.Helper helper;
    private final LoadBalancer.Factory pickFirstBalancerFactory;
    private final LoadBalancer.Factory roundRobinBalancerFactory;
    private static final Attributes.Key<AtomicReference<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.of((String)"io.grpc.grpclb.GrpclbLoadBalancer.stateInfo");
    @VisibleForTesting
    static final Metadata.Key<String> TOKEN_KEY = Metadata.Key.of((String)"lb-token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    @VisibleForTesting
    static final RoundRobinEntry DROP_ENTRY = new RoundRobinEntry(Status.UNAVAILABLE.withDescription("Drop requested by balancer"));
    @Nullable
    private LoadBalancer delegate;
    private GrpclbConstants.LbPolicy lbPolicy;
    @Nullable
    private List<LbAddressGroup> lbAddressGroups;
    @Nullable
    private ManagedChannel lbCommChannel;
    private int currentLbIndex;
    @Nullable
    private LbResponseObserver lbResponseObserver;
    @Nullable
    private StreamObserver<LoadBalanceRequest> lbRequestWriter;
    private Map<EquivalentAddressGroup, LoadBalancer.Subchannel> subchannels = Collections.emptyMap();
    private List<RoundRobinEntry> roundRobinList = Collections.emptyList();
    private LoadBalancer.SubchannelPicker currentPicker = BUFFER_PICKER;

    GrpclbLoadBalancer(LoadBalancer.Helper helper, LoadBalancer.Factory pickFirstBalancerFactory, LoadBalancer.Factory roundRobinBalancerFactory) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.serviceName = (String)Preconditions.checkNotNull((Object)helper.getAuthority(), (Object)"helper returns null authority");
        this.pickFirstBalancerFactory = (LoadBalancer.Factory)Preconditions.checkNotNull((Object)pickFirstBalancerFactory, (Object)"pickFirstBalancerFactory");
        this.roundRobinBalancerFactory = (LoadBalancer.Factory)Preconditions.checkNotNull((Object)roundRobinBalancerFactory, (Object)"roundRobinBalancerFactory");
    }

    public LogId getLogId() {
        return this.logId;
    }

    public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo newState) {
        if (this.delegate != null) {
            this.delegate.handleSubchannelState(subchannel, newState);
            return;
        }
        if (newState.getState() == ConnectivityState.SHUTDOWN || !this.subchannels.values().contains(subchannel)) {
            return;
        }
        if (newState.getState() == ConnectivityState.IDLE) {
            subchannel.requestConnection();
        }
        ((AtomicReference)subchannel.getAttributes().get(STATE_INFO)).set(newState);
        this.maybeUpdatePicker();
    }

    public void handleResolvedAddressGroups(List<EquivalentAddressGroup> updatedServers, Attributes attributes) {
        GrpclbConstants.LbPolicy newLbPolicy = (GrpclbConstants.LbPolicy)((Object)attributes.get(GrpclbConstants.ATTR_LB_POLICY));
        ArrayList<LbAddressGroup> newLbAddressGroups = new ArrayList<LbAddressGroup>();
        ArrayList<EquivalentAddressGroup> newBackendServers = new ArrayList<EquivalentAddressGroup>();
        for (EquivalentAddressGroup server : updatedServers) {
            String lbAddrAuthority = (String)server.getAttributes().get(GrpclbConstants.ATTR_LB_ADDR_AUTHORITY);
            if (lbAddrAuthority != null) {
                newLbAddressGroups.add(new LbAddressGroup(server, lbAddrAuthority));
                continue;
            }
            newBackendServers.add(server);
        }
        if (newBackendServers.isEmpty()) {
            Preconditions.checkState((!newLbAddressGroups.isEmpty() ? 1 : 0) != 0, (String)"No backend address nor LB address.  updatedServers=%s", (Object[])new Object[]{updatedServers});
            if (newLbPolicy != GrpclbConstants.LbPolicy.GRPCLB) {
                newLbPolicy = GrpclbConstants.LbPolicy.GRPCLB;
                logger.log(Level.FINE, "[{0}] Switching to GRPCLB because all addresses are balancers", this.logId);
            }
        }
        if (newLbPolicy == null) {
            logger.log(Level.FINE, "[{0}] New config missing policy. Using PICK_FIRST", this.logId);
            newLbPolicy = GrpclbConstants.LbPolicy.PICK_FIRST;
        }
        if (newLbPolicy != this.lbPolicy) {
            this.shutdownDelegate();
            this.shutdownLbComm();
            this.lbAddressGroups = null;
            this.currentLbIndex = 0;
            switch (newLbPolicy) {
                case PICK_FIRST: {
                    this.delegate = (LoadBalancer)Preconditions.checkNotNull((Object)this.pickFirstBalancerFactory.newLoadBalancer(this.helper), (Object)"pickFirstBalancerFactory.newLoadBalancer()");
                    break;
                }
                case ROUND_ROBIN: {
                    this.delegate = (LoadBalancer)Preconditions.checkNotNull((Object)this.roundRobinBalancerFactory.newLoadBalancer(this.helper), (Object)"roundRobinBalancerFactory.newLoadBalancer()");
                    break;
                }
            }
        }
        this.lbPolicy = newLbPolicy;
        switch (this.lbPolicy) {
            case PICK_FIRST: 
            case ROUND_ROBIN: {
                Preconditions.checkNotNull((Object)this.delegate, (Object)("delegate should not be null. newLbPolicy=" + (Object)((Object)newLbPolicy)));
                this.delegate.handleResolvedAddressGroups(newBackendServers, attributes);
                break;
            }
            case GRPCLB: {
                if (newLbAddressGroups.isEmpty()) {
                    this.shutdownLbComm();
                    this.lbAddressGroups = null;
                    this.handleGrpclbError(Status.UNAVAILABLE.withDescription("NameResolver returned no LB address while asking for GRPCLB"));
                    break;
                }
                int newIndexOfCurrentLb = -1;
                if (this.lbAddressGroups != null) {
                    LbAddressGroup currentLb = this.lbAddressGroups.get(this.currentLbIndex);
                    newIndexOfCurrentLb = newLbAddressGroups.indexOf(currentLb);
                }
                this.lbAddressGroups = newLbAddressGroups;
                if (newIndexOfCurrentLb == -1) {
                    this.shutdownLbComm();
                    this.currentLbIndex = 0;
                    this.startLbComm();
                    break;
                }
                this.currentLbIndex = newIndexOfCurrentLb;
                break;
            }
        }
    }

    private void shutdownLbComm() {
        if (this.lbCommChannel != null) {
            this.lbCommChannel.shutdown();
            this.lbCommChannel = null;
        }
        if (this.lbRequestWriter != null) {
            this.lbRequestWriter.onCompleted();
            this.lbRequestWriter = null;
        }
        if (this.lbResponseObserver != null) {
            this.lbResponseObserver.dismissed = true;
            this.lbResponseObserver = null;
        }
    }

    private void startLbComm() {
        Preconditions.checkState((this.lbCommChannel == null ? 1 : 0) != 0, (Object)"previous lbCommChannel has not been closed yet");
        Preconditions.checkState((this.lbRequestWriter == null ? 1 : 0) != 0, (Object)"previous lbRequestWriter has not been cleared yet");
        Preconditions.checkState((this.lbResponseObserver == null ? 1 : 0) != 0, (Object)"previous lbResponseObserver has not been cleared yet");
        LbAddressGroup currentLb = this.lbAddressGroups.get(this.currentLbIndex);
        this.lbCommChannel = this.helper.createOobChannel(currentLb.getAddresses(), currentLb.getAuthority());
        LoadBalancerGrpc.LoadBalancerStub stub = LoadBalancerGrpc.newStub((Channel)this.lbCommChannel);
        this.lbResponseObserver = new LbResponseObserver();
        this.lbRequestWriter = stub.balanceLoad(this.lbResponseObserver);
        LoadBalanceRequest initRequest = LoadBalanceRequest.newBuilder().setInitialRequest(InitialLoadBalanceRequest.newBuilder().setName(this.serviceName).build()).build();
        this.lbRequestWriter.onNext((Object)initRequest);
    }

    private void shutdownDelegate() {
        if (this.delegate != null) {
            this.delegate.shutdown();
            this.delegate = null;
        }
    }

    public void shutdown() {
        this.shutdownDelegate();
        this.shutdownLbComm();
        for (LoadBalancer.Subchannel subchannel : this.subchannels.values()) {
            subchannel.shutdown();
        }
        this.subchannels = Collections.emptyMap();
    }

    private void handleGrpclbError(Status status) {
        logger.log(Level.FINE, "[{0}] Had an error: {1}; roundRobinList={2}", new Object[]{this.logId, status, this.roundRobinList});
        if (this.roundRobinList.isEmpty()) {
            this.maybeUpdatePicker(new ErrorPicker(status));
        }
    }

    public void handleNameResolutionError(Status error) {
        if (this.delegate != null) {
            this.delegate.handleNameResolutionError(error);
        } else {
            this.handleGrpclbError(error);
        }
    }

    private void maybeUpdatePicker() {
        ArrayList<RoundRobinEntry> resultList = new ArrayList<RoundRobinEntry>();
        Status error = null;
        for (RoundRobinEntry entry : this.roundRobinList) {
            LoadBalancer.Subchannel subchannel = entry.result.getSubchannel();
            if (subchannel != null) {
                Attributes attrs = subchannel.getAttributes();
                ConnectivityStateInfo stateInfo = (ConnectivityStateInfo)((AtomicReference)attrs.get(STATE_INFO)).get();
                if (stateInfo.getState() == ConnectivityState.READY) {
                    resultList.add(entry);
                    continue;
                }
                if (stateInfo.getState() != ConnectivityState.TRANSIENT_FAILURE) continue;
                error = stateInfo.getStatus();
                continue;
            }
            resultList.add(entry);
        }
        if (resultList.isEmpty()) {
            if (error != null) {
                logger.log(Level.FINE, "[{0}] No ready Subchannel. Using error: {1}", new Object[]{this.logId, error});
                this.maybeUpdatePicker(new ErrorPicker(error));
            } else {
                logger.log(Level.FINE, "[{0}] No ready Subchannel and no error", this.logId);
                this.maybeUpdatePicker(BUFFER_PICKER);
            }
        } else {
            logger.log(Level.FINE, "[{0}] Using list {1}", new Object[]{this.logId, resultList});
            this.maybeUpdatePicker(new RoundRobinPicker(resultList));
        }
    }

    private void maybeUpdatePicker(LoadBalancer.SubchannelPicker picker) {
        if (picker == BUFFER_PICKER && this.currentPicker == BUFFER_PICKER) {
            return;
        }
        if (picker instanceof RoundRobinPicker && this.currentPicker instanceof RoundRobinPicker && ((RoundRobinPicker)picker).list.equals(((RoundRobinPicker)this.currentPicker).list)) {
            return;
        }
        this.currentPicker = picker;
        this.helper.updatePicker(picker);
    }

    @VisibleForTesting
    LoadBalancer getDelegate() {
        return this.delegate;
    }

    @VisibleForTesting
    GrpclbConstants.LbPolicy getLbPolicy() {
        return this.lbPolicy;
    }

    @VisibleForTesting
    static final class RoundRobinPicker
    extends LoadBalancer.SubchannelPicker {
        final List<RoundRobinEntry> list;
        private int index;

        RoundRobinPicker(List<RoundRobinEntry> resultList) {
            Preconditions.checkArgument((!resultList.isEmpty() ? 1 : 0) != 0, (Object)"resultList is empty");
            this.list = resultList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            List<RoundRobinEntry> list = this.list;
            synchronized (list) {
                RoundRobinEntry result = this.list.get(this.index);
                ++this.index;
                if (this.index == this.list.size()) {
                    this.index = 0;
                }
                result.updateHeaders(args.getHeaders());
                return result.result;
            }
        }
    }

    @VisibleForTesting
    static final class RoundRobinEntry {
        final LoadBalancer.PickResult result;
        @Nullable
        private final String token;

        RoundRobinEntry(LoadBalancer.Subchannel subchannel, String token) {
            this.result = LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel);
            this.token = token;
        }

        RoundRobinEntry(Status dropStatus) {
            this.result = LoadBalancer.PickResult.withError((Status)dropStatus);
            this.token = null;
        }

        void updateHeaders(Metadata headers) {
            if (this.token != null) {
                headers.discardAll(TOKEN_KEY);
                headers.put(TOKEN_KEY, (Object)this.token);
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("result", (Object)this.result).add("token", (Object)this.token).toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.result, this.token});
        }

        public boolean equals(Object other) {
            if (!(other instanceof RoundRobinEntry)) {
                return false;
            }
            RoundRobinEntry that = (RoundRobinEntry)other;
            return Objects.equal((Object)this.result, (Object)that.result) && Objects.equal((Object)this.token, (Object)that.token);
        }
    }

    @VisibleForTesting
    static final class ErrorPicker
    extends LoadBalancer.SubchannelPicker {
        final LoadBalancer.PickResult result;

        ErrorPicker(Status status) {
            this.result = LoadBalancer.PickResult.withError((Status)status);
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return this.result;
        }
    }

    private class LbResponseObserver
    implements StreamObserver<LoadBalanceResponse> {
        boolean dismissed;

        private LbResponseObserver() {
        }

        public void onNext(final LoadBalanceResponse response) {
            GrpclbLoadBalancer.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    LbResponseObserver.this.handleResponse(response);
                }
            });
        }

        private void handleResponse(LoadBalanceResponse response) {
            if (this.dismissed) {
                return;
            }
            logger.log(Level.FINE, "[{0}] Got an LB response: {1}", new Object[]{GrpclbLoadBalancer.this.logId, response});
            ServerList serverList = response.getServerList();
            HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel> newSubchannelMap = new HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel>();
            ArrayList<RoundRobinEntry> newRoundRobinList = new ArrayList<RoundRobinEntry>();
            for (Server server : serverList.getServersList()) {
                InetSocketAddress address;
                if (server.getDropRequest()) {
                    newRoundRobinList.add(DROP_ENTRY);
                    continue;
                }
                try {
                    address = new InetSocketAddress(InetAddress.getByAddress(server.getIpAddress().toByteArray()), server.getPort());
                }
                catch (UnknownHostException e) {
                    GrpclbLoadBalancer.this.handleGrpclbError(Status.UNAVAILABLE.withCause((Throwable)e));
                    continue;
                }
                EquivalentAddressGroup eag = new EquivalentAddressGroup((SocketAddress)address);
                String token = server.getLoadBalanceToken();
                LoadBalancer.Subchannel subchannel = (LoadBalancer.Subchannel)newSubchannelMap.get(eag);
                if (subchannel == null) {
                    subchannel = (LoadBalancer.Subchannel)GrpclbLoadBalancer.this.subchannels.get(eag);
                    if (subchannel == null) {
                        Attributes subchannelAttrs = Attributes.newBuilder().set(STATE_INFO, new AtomicReference<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError((ConnectivityState)ConnectivityState.IDLE))).build();
                        subchannel = GrpclbLoadBalancer.this.helper.createSubchannel(eag, subchannelAttrs);
                        subchannel.requestConnection();
                    }
                    newSubchannelMap.put(eag, subchannel);
                }
                newRoundRobinList.add(new RoundRobinEntry(subchannel, token));
            }
            for (Map.Entry entry : GrpclbLoadBalancer.this.subchannels.entrySet()) {
                EquivalentAddressGroup eag = (EquivalentAddressGroup)entry.getKey();
                if (newSubchannelMap.containsKey(eag)) continue;
                ((LoadBalancer.Subchannel)entry.getValue()).shutdown();
            }
            GrpclbLoadBalancer.this.subchannels = newSubchannelMap;
            GrpclbLoadBalancer.this.roundRobinList = newRoundRobinList;
            GrpclbLoadBalancer.this.maybeUpdatePicker();
        }

        public void onError(final Throwable error) {
            GrpclbLoadBalancer.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    LbResponseObserver.this.handleStreamClosed(Status.fromThrowable((Throwable)error).augmentDescription("Stream to GRPCLB LoadBalancer had an error"));
                }
            });
        }

        public void onCompleted() {
            GrpclbLoadBalancer.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    LbResponseObserver.this.handleStreamClosed(Status.UNAVAILABLE.augmentDescription("Stream to GRPCLB LoadBalancer was closed"));
                }
            });
        }

        private void handleStreamClosed(Status status) {
            if (this.dismissed) {
                return;
            }
            GrpclbLoadBalancer.this.lbRequestWriter = null;
            GrpclbLoadBalancer.this.handleGrpclbError(status);
            GrpclbLoadBalancer.this.shutdownLbComm();
            GrpclbLoadBalancer.this.currentLbIndex = (GrpclbLoadBalancer.this.currentLbIndex + 1) % GrpclbLoadBalancer.this.lbAddressGroups.size();
            GrpclbLoadBalancer.this.startLbComm();
        }
    }
}

