/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.base.Preconditions;
import com.google.protobuf.util.Timestamps;
import io.grpc.ClientStreamTracer;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.grpclb.ClientStats;
import io.grpc.grpclb.DropType;
import io.grpc.grpclb.TimeProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class GrpclbClientLoadRecorder
extends ClientStreamTracer.Factory {
    private final TimeProvider time;
    private final AtomicLong callsStarted = new AtomicLong();
    private final AtomicLong callsFinished = new AtomicLong();
    private final AtomicLong callsDroppedForRateLimiting = new AtomicLong();
    private final AtomicLong callsDroppedForLoadBalancing = new AtomicLong();
    private final AtomicLong callsFailedToSend = new AtomicLong();
    private final AtomicLong callsFinishedKnownReceived = new AtomicLong();

    GrpclbClientLoadRecorder(TimeProvider time) {
        this.time = (TimeProvider)Preconditions.checkNotNull((Object)time, (Object)"time provider");
    }

    public ClientStreamTracer newClientStreamTracer(Metadata headers) {
        this.callsStarted.incrementAndGet();
        return new StreamTracer();
    }

    void recordDroppedRequest(DropType type) {
        this.callsStarted.incrementAndGet();
        this.callsFinished.incrementAndGet();
        switch (type) {
            case RATE_LIMITING: {
                this.callsDroppedForRateLimiting.incrementAndGet();
                break;
            }
            case LOAD_BALANCING: {
                this.callsDroppedForLoadBalancing.incrementAndGet();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported DropType: " + (Object)((Object)type)));
            }
        }
    }

    ClientStats generateLoadReport() {
        return ClientStats.newBuilder().setTimestamp(Timestamps.fromMillis((long)this.time.currentTimeMillis())).setNumCallsStarted(this.callsStarted.getAndSet(0L)).setNumCallsFinished(this.callsFinished.getAndSet(0L)).setNumCallsFinishedWithDropForRateLimiting(this.callsDroppedForRateLimiting.getAndSet(0L)).setNumCallsFinishedWithDropForLoadBalancing(this.callsDroppedForLoadBalancing.getAndSet(0L)).setNumCallsFinishedWithClientFailedToSend(this.callsFailedToSend.getAndSet(0L)).setNumCallsFinishedKnownReceived(this.callsFinishedKnownReceived.getAndSet(0L)).build();
    }

    private class StreamTracer
    extends ClientStreamTracer {
        final AtomicBoolean headersSent = new AtomicBoolean();
        final AtomicBoolean anythingReceived = new AtomicBoolean();

        private StreamTracer() {
        }

        public void outboundHeaders() {
            this.headersSent.set(true);
        }

        public void inboundHeaders() {
            this.anythingReceived.set(true);
        }

        public void inboundMessage() {
            this.anythingReceived.set(true);
        }

        public void streamClosed(Status status) {
            GrpclbClientLoadRecorder.this.callsFinished.incrementAndGet();
            if (!this.headersSent.get()) {
                GrpclbClientLoadRecorder.this.callsFailedToSend.incrementAndGet();
            }
            if (this.anythingReceived.get()) {
                GrpclbClientLoadRecorder.this.callsFinishedKnownReceived.incrementAndGet();
            }
        }
    }
}

