/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.base.Preconditions;
import com.google.protobuf.util.Timestamps;
import io.grpc.CallOptions;
import io.grpc.ClientStreamTracer;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.grpclb.ClientStats;
import io.grpc.grpclb.ClientStatsPerToken;
import io.grpc.grpclb.TimeProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class GrpclbClientLoadRecorder
extends ClientStreamTracer.Factory {
    private final TimeProvider time;
    private final AtomicLong callsStarted = new AtomicLong();
    private final AtomicLong callsFinished = new AtomicLong();
    @GuardedBy(value="this")
    private HashMap<String, AtomicLong> callsDroppedPerToken = new HashMap();
    private final AtomicLong callsFailedToSend = new AtomicLong();
    private final AtomicLong callsFinishedKnownReceived = new AtomicLong();

    GrpclbClientLoadRecorder(TimeProvider time) {
        this.time = (TimeProvider)Preconditions.checkNotNull((Object)time, (Object)"time provider");
    }

    public ClientStreamTracer newClientStreamTracer(CallOptions callOptions, Metadata headers) {
        this.callsStarted.incrementAndGet();
        return new StreamTracer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordDroppedRequest(String token) {
        this.callsStarted.incrementAndGet();
        this.callsFinished.incrementAndGet();
        GrpclbClientLoadRecorder grpclbClientLoadRecorder = this;
        synchronized (grpclbClientLoadRecorder) {
            AtomicLong count = this.callsDroppedPerToken.get(token);
            if (count == null) {
                count = new AtomicLong(1L);
                this.callsDroppedPerToken.put(token, count);
            } else {
                count.incrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientStats generateLoadReport() {
        HashMap<String, AtomicLong> savedCallsDroppedPerToken;
        ClientStats.Builder statsBuilder = ClientStats.newBuilder().setTimestamp(Timestamps.fromMillis((long)this.time.currentTimeMillis())).setNumCallsStarted(this.callsStarted.getAndSet(0L)).setNumCallsFinished(this.callsFinished.getAndSet(0L)).setNumCallsFinishedWithClientFailedToSend(this.callsFailedToSend.getAndSet(0L)).setNumCallsFinishedKnownReceived(this.callsFinishedKnownReceived.getAndSet(0L));
        GrpclbClientLoadRecorder grpclbClientLoadRecorder = this;
        synchronized (grpclbClientLoadRecorder) {
            savedCallsDroppedPerToken = this.callsDroppedPerToken;
            this.callsDroppedPerToken = new HashMap();
        }
        for (Map.Entry entry : savedCallsDroppedPerToken.entrySet()) {
            statsBuilder.addCallsFinishedWithDrop(ClientStatsPerToken.newBuilder().setLoadBalanceToken((String)entry.getKey()).setNumCalls(((AtomicLong)entry.getValue()).get()).build());
        }
        return statsBuilder.build();
    }

    private class StreamTracer
    extends ClientStreamTracer {
        final AtomicBoolean headersSent = new AtomicBoolean();
        final AtomicBoolean anythingReceived = new AtomicBoolean();

        private StreamTracer() {
        }

        public void outboundHeaders() {
            this.headersSent.set(true);
        }

        public void inboundHeaders() {
            this.anythingReceived.set(true);
        }

        public void inboundMessage() {
            this.anythingReceived.set(true);
        }

        public void streamClosed(Status status) {
            GrpclbClientLoadRecorder.this.callsFinished.incrementAndGet();
            if (!this.headersSent.get()) {
                GrpclbClientLoadRecorder.this.callsFailedToSend.incrementAndGet();
            }
            if (this.anythingReceived.get()) {
                GrpclbClientLoadRecorder.this.callsFinishedKnownReceived.incrementAndGet();
            }
        }
    }
}

