/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.service;

import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import io.grpc.BindableService;
import io.grpc.InternalNotifyOnServerBuild;
import io.grpc.Server;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.reflection.v1alpha.ErrorResponse;
import io.grpc.reflection.v1alpha.ExtensionNumberResponse;
import io.grpc.reflection.v1alpha.ExtensionRequest;
import io.grpc.reflection.v1alpha.FileDescriptorResponse;
import io.grpc.reflection.v1alpha.ListServiceResponse;
import io.grpc.reflection.v1alpha.ServerReflectionGrpc;
import io.grpc.reflection.v1alpha.ServerReflectionRequest;
import io.grpc.reflection.v1alpha.ServerReflectionResponse;
import io.grpc.reflection.v1alpha.ServiceResponse;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class ProtoReflectionService
extends ServerReflectionGrpc.ServerReflectionImplBase
implements InternalNotifyOnServerBuild {
    private volatile ServerReflectionIndex serverReflectionIndex;

    private ProtoReflectionService() {
    }

    public static BindableService getInstance() {
        return new ProtoReflectionService();
    }

    public void notifyOnBuild(Server server) {
        Preconditions.checkState((this.serverReflectionIndex == null ? 1 : 0) != 0);
        this.serverReflectionIndex = new ServerReflectionIndex((Server)Preconditions.checkNotNull((Object)server, (Object)"server"));
    }

    @Override
    public StreamObserver<ServerReflectionRequest> serverReflectionInfo(StreamObserver<ServerReflectionResponse> responseObserver) {
        Preconditions.checkState((this.serverReflectionIndex != null ? 1 : 0) != 0);
        this.serverReflectionIndex.initializeImmutableServicesIndex();
        ServerCallStreamObserver serverCallStreamObserver = (ServerCallStreamObserver)responseObserver;
        ProtoReflectionStreamObserver requestObserver = new ProtoReflectionStreamObserver((ServerCallStreamObserver<ServerReflectionResponse>)serverCallStreamObserver);
        serverCallStreamObserver.setOnReadyHandler((Runnable)requestObserver);
        serverCallStreamObserver.disableAutoInboundFlowControl();
        serverCallStreamObserver.request(1);
        return requestObserver;
    }

    private static final class FileDescriptorIndex {
        private final Set<String> serviceNames = new HashSet<String>();
        private final Set<Descriptors.FileDescriptor> serviceFileDescriptors = new HashSet<Descriptors.FileDescriptor>();
        private final Map<String, Descriptors.FileDescriptor> fileDescriptorsByName = new HashMap<String, Descriptors.FileDescriptor>();
        private final Map<String, Descriptors.FileDescriptor> fileDescriptorsBySymbol = new HashMap<String, Descriptors.FileDescriptor>();
        private final Map<String, Map<Integer, Descriptors.FileDescriptor>> fileDescriptorsByExtensionAndNumber = new HashMap<String, Map<Integer, Descriptors.FileDescriptor>>();

        FileDescriptorIndex(List<ServerServiceDefinition> services) {
            LinkedList<Descriptors.FileDescriptor> fileDescriptorsToProcess = new LinkedList<Descriptors.FileDescriptor>();
            HashSet<String> seenFiles = new HashSet<String>();
            for (ServerServiceDefinition service : services) {
                ServiceDescriptor serviceDescriptor = service.getServiceDescriptor();
                if (!(serviceDescriptor.getSchemaDescriptor() instanceof ProtoFileDescriptorSupplier)) continue;
                Descriptors.FileDescriptor fileDescriptor = ((ProtoFileDescriptorSupplier)serviceDescriptor.getSchemaDescriptor()).getFileDescriptor();
                String serviceName = serviceDescriptor.getName();
                Preconditions.checkState((!this.serviceNames.contains(serviceName) ? 1 : 0) != 0, (String)"Service already defined: %s", (Object)serviceName);
                this.serviceFileDescriptors.add(fileDescriptor);
                this.serviceNames.add(serviceName);
                if (seenFiles.contains(fileDescriptor.getName())) continue;
                seenFiles.add(fileDescriptor.getName());
                fileDescriptorsToProcess.add(fileDescriptor);
            }
            while (!fileDescriptorsToProcess.isEmpty()) {
                Descriptors.FileDescriptor currentFd = (Descriptors.FileDescriptor)fileDescriptorsToProcess.remove();
                this.processFileDescriptor(currentFd);
                for (Descriptors.FileDescriptor dependencyFd : currentFd.getDependencies()) {
                    if (seenFiles.contains(dependencyFd.getName())) continue;
                    seenFiles.add(dependencyFd.getName());
                    fileDescriptorsToProcess.add(dependencyFd);
                }
            }
        }

        private Set<Descriptors.FileDescriptor> getServiceFileDescriptors() {
            return Collections.unmodifiableSet(this.serviceFileDescriptors);
        }

        private Set<String> getServiceNames() {
            return Collections.unmodifiableSet(this.serviceNames);
        }

        @Nullable
        private Descriptors.FileDescriptor getFileDescriptorByName(String name) {
            return this.fileDescriptorsByName.get(name);
        }

        @Nullable
        private Descriptors.FileDescriptor getFileDescriptorBySymbol(String symbol) {
            return this.fileDescriptorsBySymbol.get(symbol);
        }

        @Nullable
        private Descriptors.FileDescriptor getFileDescriptorByExtensionAndNumber(String type, int number) {
            if (this.fileDescriptorsByExtensionAndNumber.containsKey(type)) {
                return this.fileDescriptorsByExtensionAndNumber.get(type).get(number);
            }
            return null;
        }

        @Nullable
        private Set<Integer> getExtensionNumbersOfType(String type) {
            if (this.fileDescriptorsByExtensionAndNumber.containsKey(type)) {
                return Collections.unmodifiableSet(this.fileDescriptorsByExtensionAndNumber.get(type).keySet());
            }
            return null;
        }

        private void processFileDescriptor(Descriptors.FileDescriptor fd) {
            String fdName = fd.getName();
            Preconditions.checkState((!this.fileDescriptorsByName.containsKey(fdName) ? 1 : 0) != 0, (String)"File name already used: %s", (Object)fdName);
            this.fileDescriptorsByName.put(fdName, fd);
            for (Descriptors.ServiceDescriptor service : fd.getServices()) {
                this.processService(service, fd);
            }
            for (Descriptors.Descriptor type : fd.getMessageTypes()) {
                this.processType(type, fd);
            }
            for (Descriptors.FieldDescriptor extension : fd.getExtensions()) {
                this.processExtension(extension, fd);
            }
        }

        private void processService(Descriptors.ServiceDescriptor service, Descriptors.FileDescriptor fd) {
            String serviceName = service.getFullName();
            Preconditions.checkState((!this.fileDescriptorsBySymbol.containsKey(serviceName) ? 1 : 0) != 0, (String)"Service already defined: %s", (Object)serviceName);
            this.fileDescriptorsBySymbol.put(serviceName, fd);
            for (Descriptors.MethodDescriptor method : service.getMethods()) {
                String methodName = method.getFullName();
                Preconditions.checkState((!this.fileDescriptorsBySymbol.containsKey(methodName) ? 1 : 0) != 0, (String)"Method already defined: %s", (Object)methodName);
                this.fileDescriptorsBySymbol.put(methodName, fd);
            }
        }

        private void processType(Descriptors.Descriptor type, Descriptors.FileDescriptor fd) {
            String typeName = type.getFullName();
            Preconditions.checkState((!this.fileDescriptorsBySymbol.containsKey(typeName) ? 1 : 0) != 0, (String)"Type already defined: %s", (Object)typeName);
            this.fileDescriptorsBySymbol.put(typeName, fd);
            for (Descriptors.FieldDescriptor extension : type.getExtensions()) {
                this.processExtension(extension, fd);
            }
            for (Descriptors.Descriptor nestedType : type.getNestedTypes()) {
                this.processType(nestedType, fd);
            }
        }

        private void processExtension(Descriptors.FieldDescriptor extension, Descriptors.FileDescriptor fd) {
            String extensionName = extension.getContainingType().getFullName();
            int extensionNumber = extension.getNumber();
            if (!this.fileDescriptorsByExtensionAndNumber.containsKey(extensionName)) {
                this.fileDescriptorsByExtensionAndNumber.put(extensionName, new HashMap());
            }
            Preconditions.checkState((!this.fileDescriptorsByExtensionAndNumber.get(extensionName).containsKey(extensionNumber) ? 1 : 0) != 0, (String)"Extension name and number already defined: %s, %s", (Object)extensionName, (int)extensionNumber);
            this.fileDescriptorsByExtensionAndNumber.get(extensionName).put(extensionNumber, fd);
        }
    }

    private static final class ServerReflectionIndex {
        private FileDescriptorIndex immutableServicesIndex;
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private FileDescriptorIndex mutableServicesIndex = new FileDescriptorIndex(Collections.<ServerServiceDefinition>emptyList());
        private final Server server;

        public ServerReflectionIndex(Server server) {
            this.server = server;
        }

        private synchronized void initializeImmutableServicesIndex() {
            if (this.immutableServicesIndex == null) {
                this.immutableServicesIndex = new FileDescriptorIndex(this.server.getImmutableServices());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateMutableIndexIfNecessary() {
            HashSet<Descriptors.FileDescriptor> currentFileDescriptors = new HashSet<Descriptors.FileDescriptor>();
            HashSet<String> currentServiceNames = new HashSet<String>();
            Object object = this.lock;
            synchronized (object) {
                List currentMutableServices = this.server.getMutableServices();
                for (ServerServiceDefinition mutableService : currentMutableServices) {
                    ServiceDescriptor serviceDescriptor = mutableService.getServiceDescriptor();
                    if (!(serviceDescriptor.getSchemaDescriptor() instanceof ProtoFileDescriptorSupplier)) continue;
                    String serviceName = serviceDescriptor.getName();
                    Descriptors.FileDescriptor fileDescriptor = ((ProtoFileDescriptorSupplier)serviceDescriptor.getSchemaDescriptor()).getFileDescriptor();
                    currentFileDescriptors.add(fileDescriptor);
                    Preconditions.checkState((!currentServiceNames.contains(serviceName) ? 1 : 0) != 0, (String)"Service already defined: %s", (Object)serviceName);
                    currentServiceNames.add(serviceName);
                }
                if (!this.mutableServicesIndex.getServiceFileDescriptors().equals(currentFileDescriptors) || !this.mutableServicesIndex.getServiceNames().equals(currentServiceNames)) {
                    this.mutableServicesIndex = new FileDescriptorIndex(currentMutableServices);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> getServiceNames() {
            HashSet<String> serviceNames = new HashSet<String>(this.immutableServicesIndex.getServiceNames());
            Object object = this.lock;
            synchronized (object) {
                serviceNames.addAll(this.mutableServicesIndex.getServiceNames());
            }
            return serviceNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Descriptors.FileDescriptor getFileDescriptorByName(String name) {
            Descriptors.FileDescriptor fd = this.immutableServicesIndex.getFileDescriptorByName(name);
            if (fd == null) {
                Object object = this.lock;
                synchronized (object) {
                    fd = this.mutableServicesIndex.getFileDescriptorByName(name);
                }
            }
            return fd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Descriptors.FileDescriptor getFileDescriptorBySymbol(String symbol) {
            Descriptors.FileDescriptor fd = this.immutableServicesIndex.getFileDescriptorBySymbol(symbol);
            if (fd == null) {
                Object object = this.lock;
                synchronized (object) {
                    fd = this.mutableServicesIndex.getFileDescriptorBySymbol(symbol);
                }
            }
            return fd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Descriptors.FileDescriptor getFileDescriptorByExtensionAndNumber(String type, int extension) {
            Descriptors.FileDescriptor fd = this.immutableServicesIndex.getFileDescriptorByExtensionAndNumber(type, extension);
            if (fd == null) {
                Object object = this.lock;
                synchronized (object) {
                    fd = this.mutableServicesIndex.getFileDescriptorByExtensionAndNumber(type, extension);
                }
            }
            return fd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Set<Integer> getExtensionNumbersOfType(String type) {
            Set extensionNumbers = this.immutableServicesIndex.getExtensionNumbersOfType(type);
            if (extensionNumbers == null) {
                Object object = this.lock;
                synchronized (object) {
                    extensionNumbers = this.mutableServicesIndex.getExtensionNumbersOfType(type);
                }
            }
            return extensionNumbers;
        }
    }

    private class ProtoReflectionStreamObserver
    implements Runnable,
    StreamObserver<ServerReflectionRequest> {
        private final ServerCallStreamObserver<ServerReflectionResponse> serverCallStreamObserver;
        private boolean closeAfterSend = false;
        private ServerReflectionRequest request;

        ProtoReflectionStreamObserver(ServerCallStreamObserver<ServerReflectionResponse> serverCallStreamObserver) {
            this.serverCallStreamObserver = (ServerCallStreamObserver)Preconditions.checkNotNull(serverCallStreamObserver, (Object)"observer");
        }

        @Override
        public void run() {
            if (this.request != null) {
                this.handleReflectionRequest();
            }
        }

        public void onNext(ServerReflectionRequest request) {
            Preconditions.checkState((this.request == null ? 1 : 0) != 0);
            this.request = (ServerReflectionRequest)Preconditions.checkNotNull((Object)request);
            this.handleReflectionRequest();
        }

        private void handleReflectionRequest() {
            if (this.serverCallStreamObserver.isReady()) {
                ProtoReflectionService.this.serverReflectionIndex.updateMutableIndexIfNecessary();
                switch (this.request.getMessageRequestCase()) {
                    case FILE_BY_FILENAME: {
                        this.getFileByName(this.request);
                        break;
                    }
                    case FILE_CONTAINING_SYMBOL: {
                        this.getFileContainingSymbol(this.request);
                        break;
                    }
                    case FILE_CONTAINING_EXTENSION: {
                        this.getFileByExtension(this.request);
                        break;
                    }
                    case ALL_EXTENSION_NUMBERS_OF_TYPE: {
                        this.getAllExtensions(this.request);
                        break;
                    }
                    case LIST_SERVICES: {
                        this.listServices(this.request);
                        break;
                    }
                    default: {
                        this.sendErrorResponse(this.request, Status.UNIMPLEMENTED, "");
                    }
                }
                this.request = null;
                if (this.closeAfterSend) {
                    this.serverCallStreamObserver.onCompleted();
                } else {
                    this.serverCallStreamObserver.request(1);
                }
            }
        }

        public void onCompleted() {
            if (this.request != null) {
                this.closeAfterSend = true;
            } else {
                this.serverCallStreamObserver.onCompleted();
            }
        }

        public void onError(Throwable cause) {
            this.serverCallStreamObserver.onError(cause);
        }

        private void getFileByName(ServerReflectionRequest request) {
            String name = request.getFileByFilename();
            Descriptors.FileDescriptor fd = ProtoReflectionService.this.serverReflectionIndex.getFileDescriptorByName(name);
            if (fd != null) {
                this.serverCallStreamObserver.onNext((Object)this.createServerReflectionResponse(request, fd));
            } else {
                this.sendErrorResponse(request, Status.NOT_FOUND, "File not found.");
            }
        }

        private void getFileContainingSymbol(ServerReflectionRequest request) {
            String symbol = request.getFileContainingSymbol();
            Descriptors.FileDescriptor fd = ProtoReflectionService.this.serverReflectionIndex.getFileDescriptorBySymbol(symbol);
            if (fd != null) {
                this.serverCallStreamObserver.onNext((Object)this.createServerReflectionResponse(request, fd));
            } else {
                this.sendErrorResponse(request, Status.NOT_FOUND, "Symbol not found.");
            }
        }

        private void getFileByExtension(ServerReflectionRequest request) {
            ExtensionRequest extensionRequest = request.getFileContainingExtension();
            String type = extensionRequest.getContainingType();
            int extension = extensionRequest.getExtensionNumber();
            Descriptors.FileDescriptor fd = ProtoReflectionService.this.serverReflectionIndex.getFileDescriptorByExtensionAndNumber(type, extension);
            if (fd != null) {
                this.serverCallStreamObserver.onNext((Object)this.createServerReflectionResponse(request, fd));
            } else {
                this.sendErrorResponse(request, Status.NOT_FOUND, "Extension not found.");
            }
        }

        private void getAllExtensions(ServerReflectionRequest request) {
            String type = request.getAllExtensionNumbersOfType();
            Set extensions = ProtoReflectionService.this.serverReflectionIndex.getExtensionNumbersOfType(type);
            if (extensions != null) {
                ExtensionNumberResponse.Builder builder = ExtensionNumberResponse.newBuilder().setBaseTypeName(type).addAllExtensionNumber(extensions);
                this.serverCallStreamObserver.onNext((Object)ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setAllExtensionNumbersResponse(builder).build());
            } else {
                this.sendErrorResponse(request, Status.NOT_FOUND, "Type not found.");
            }
        }

        private void listServices(ServerReflectionRequest request) {
            ListServiceResponse.Builder builder = ListServiceResponse.newBuilder();
            for (String serviceName : ProtoReflectionService.this.serverReflectionIndex.getServiceNames()) {
                builder.addService(ServiceResponse.newBuilder().setName(serviceName));
            }
            this.serverCallStreamObserver.onNext((Object)ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setListServicesResponse(builder).build());
        }

        private void sendErrorResponse(ServerReflectionRequest request, Status status, String message) {
            ServerReflectionResponse response = ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setErrorResponse(ErrorResponse.newBuilder().setErrorCode(status.getCode().value()).setErrorMessage(message)).build();
            this.serverCallStreamObserver.onNext((Object)response);
        }

        private ServerReflectionResponse createServerReflectionResponse(ServerReflectionRequest request, Descriptors.FileDescriptor fd) {
            FileDescriptorResponse.Builder fdRBuilder = FileDescriptorResponse.newBuilder();
            HashSet<String> seenFiles = new HashSet<String>();
            LinkedList<Descriptors.FileDescriptor> frontier = new LinkedList<Descriptors.FileDescriptor>();
            seenFiles.add(fd.getName());
            frontier.add(fd);
            while (!frontier.isEmpty()) {
                Descriptors.FileDescriptor nextFd = (Descriptors.FileDescriptor)frontier.remove();
                fdRBuilder.addFileDescriptorProto(nextFd.toProto().toByteString());
                for (Descriptors.FileDescriptor dependencyFd : nextFd.getDependencies()) {
                    if (seenFiles.contains(dependencyFd.getName())) continue;
                    seenFiles.add(dependencyFd.getName());
                    frontier.add(dependencyFd);
                }
            }
            return ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setFileDescriptorResponse(fdRBuilder).build();
        }
    }
}

