/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.primitives.Bytes;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Grpc;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.binarylog.GrpcLogEntry;
import io.grpc.binarylog.Message;
import io.grpc.binarylog.Metadata;
import io.grpc.binarylog.MetadataEntry;
import io.grpc.binarylog.Peer;
import io.grpc.binarylog.Uint128;
import io.grpc.internal.BinaryLogProvider;
import io.grpc.services.BinaryLogSink;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class BinaryLog
implements ServerInterceptor,
ClientInterceptor {
    private static final Logger logger = Logger.getLogger(BinaryLog.class.getName());
    private static final int IP_PORT_BYTES = 2;
    private static final int IP_PORT_UPPER_MASK = 65280;
    private static final int IP_PORT_LOWER_MASK = 255;
    private static final boolean SERVER = true;
    private static final boolean CLIENT = false;
    @VisibleForTesting
    static final BinaryLogProvider.CallId emptyCallId = new BinaryLogProvider.CallId(0L, 0L);
    @VisibleForTesting
    static final SocketAddress DUMMY_SOCKET = new DummySocketAddress();
    @VisibleForTesting
    static final boolean DUMMY_IS_COMPRESSED = false;
    @VisibleForTesting
    final SinkWriter writer;

    @VisibleForTesting
    BinaryLog(SinkWriter writer) {
        this.writer = writer;
    }

    static BinaryLogProvider.CallId getCallIdForServer(Context context) {
        BinaryLogProvider.CallId callId = (BinaryLogProvider.CallId)BinaryLogProvider.SERVER_CALL_ID_CONTEXT_KEY.get(context);
        if (callId == null) {
            return emptyCallId;
        }
        return callId;
    }

    static BinaryLogProvider.CallId getCallIdForClient(CallOptions callOptions) {
        BinaryLogProvider.CallId callId = (BinaryLogProvider.CallId)callOptions.getOption(BinaryLogProvider.CLIENT_CALL_ID_CALLOPTION_KEY);
        if (callId == null) {
            return emptyCallId;
        }
        return callId;
    }

    static SocketAddress getPeerSocket(Attributes streamAttributes) {
        SocketAddress peer = (SocketAddress)streamAttributes.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
        if (peer == null) {
            return DUMMY_SOCKET;
        }
        return peer;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        final BinaryLogProvider.CallId callId = BinaryLog.getCallIdForClient(callOptions);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                BinaryLog.this.writer.logSendInitialMetadata(headers, false, callId);
                ForwardingClientCallListener.SimpleForwardingClientCallListener wListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onMessage(RespT message) {
                        BinaryLog.this.writer.logInboundMessage(method.getResponseMarshaller(), message, false, false, callId);
                        super.onMessage(message);
                    }

                    public void onHeaders(Metadata headers) {
                        SocketAddress peer = BinaryLog.getPeerSocket(this.getAttributes());
                        BinaryLog.this.writer.logRecvInitialMetadata(headers, false, callId, peer);
                        super.onHeaders(headers);
                    }

                    public void onClose(Status status, Metadata trailers) {
                        BinaryLog.this.writer.logTrailingMetadata(trailers, false, callId);
                        super.onClose(status, trailers);
                    }
                };
                super.start((ClientCall.Listener)wListener, headers);
            }

            public void sendMessage(ReqT message) {
                BinaryLog.this.writer.logOutboundMessage(method.getRequestMarshaller(), message, false, false, callId);
                super.sendMessage(message);
            }
        };
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        final BinaryLogProvider.CallId callId = BinaryLog.getCallIdForServer(Context.current());
        SocketAddress peer = BinaryLog.getPeerSocket(call.getAttributes());
        this.writer.logRecvInitialMetadata(headers, true, callId, peer);
        ForwardingServerCall.SimpleForwardingServerCall wCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void sendMessage(RespT message) {
                BinaryLog.this.writer.logOutboundMessage(call.getMethodDescriptor().getResponseMarshaller(), message, false, true, callId);
                super.sendMessage(message);
            }

            public void sendHeaders(Metadata headers) {
                BinaryLog.this.writer.logSendInitialMetadata(headers, true, callId);
                super.sendHeaders(headers);
            }

            public void close(Status status, Metadata trailers) {
                BinaryLog.this.writer.logTrailingMetadata(trailers, true, callId);
                super.close(status, trailers);
            }
        };
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall((ServerCall)wCall, headers)){

            public void onMessage(ReqT message) {
                BinaryLog.this.writer.logInboundMessage(call.getMethodDescriptor().getRequestMarshaller(), message, false, true, callId);
                super.onMessage(message);
            }
        };
    }

    static Uint128 callIdToProto(BinaryLogProvider.CallId callId) {
        Preconditions.checkNotNull((Object)callId);
        return Uint128.newBuilder().setHigh(callId.hi).setLow(callId.lo).build();
    }

    @VisibleForTesting
    static Peer socketToProto(SocketAddress address) {
        Preconditions.checkNotNull((Object)address);
        Peer.PeerType peerType = Peer.PeerType.UNKNOWN_PEERTYPE;
        byte[] peerAddress = null;
        if (address instanceof InetSocketAddress) {
            InetAddress inetAddress = ((InetSocketAddress)address).getAddress();
            if (inetAddress instanceof Inet4Address) {
                peerType = Peer.PeerType.PEER_IPV4;
            } else if (inetAddress instanceof Inet6Address) {
                peerType = Peer.PeerType.PEER_IPV6;
            } else {
                logger.log(Level.SEVERE, "unknown type of InetSocketAddress: {}", address);
            }
            int port = ((InetSocketAddress)address).getPort();
            byte[] portBytes = new byte[]{(byte)((port & 0xFF00) >> 8), (byte)(port & 0xFF)};
            peerAddress = Bytes.concat((byte[][])new byte[][]{inetAddress.getAddress(), portBytes});
        } else if (address.getClass().getName().equals("io.netty.channel.unix.DomainSocketAddress")) {
            peerType = Peer.PeerType.PEER_UNIX;
        }
        if (peerAddress == null) {
            peerAddress = address.toString().getBytes(Charset.defaultCharset());
        }
        return Peer.newBuilder().setPeerType(peerType).setPeer(ByteString.copyFrom((byte[])peerAddress)).build();
    }

    @VisibleForTesting
    static io.grpc.binarylog.Metadata metadataToProto(Metadata metadata, int maxHeaderBytes) {
        byte[][] serialized;
        Preconditions.checkNotNull((Object)metadata);
        Preconditions.checkState((maxHeaderBytes >= 0 ? 1 : 0) != 0);
        Metadata.Builder builder = io.grpc.binarylog.Metadata.newBuilder();
        if (maxHeaderBytes > 0 && (serialized = InternalMetadata.serialize((Metadata)metadata)) != null) {
            int written = 0;
            for (int i = 0; i < serialized.length && written < maxHeaderBytes; i += 2) {
                byte[] key = serialized[i];
                byte[] value = serialized[i + 1];
                if (written + key.length + value.length > maxHeaderBytes) continue;
                builder.addEntry(MetadataEntry.newBuilder().setKey(ByteString.copyFrom((byte[])key)).setValue(ByteString.copyFrom((byte[])value)).build());
                written += key.length;
                written += value.length;
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static Message messageToProto(byte[] message, boolean compressed, int maxMessageBytes) {
        Preconditions.checkNotNull((Object)message);
        Message.Builder builder = Message.newBuilder().setFlags(BinaryLog.flagsForMessage(compressed)).setLength(message.length);
        if (maxMessageBytes > 0) {
            int desiredBytes = Math.min(maxMessageBytes, message.length);
            builder.setData(ByteString.copyFrom((byte[])message, (int)0, (int)desiredBytes));
        }
        return builder.build();
    }

    @VisibleForTesting
    static int flagsForMessage(boolean compressed) {
        return compressed ? 1 : 0;
    }

    private static class DummySocketAddress
    extends SocketAddress {
        private static final long serialVersionUID = 0L;

        private DummySocketAddress() {
        }
    }

    static final class FactoryImpl
    implements Factory {
        private static final Pattern logPatternRe = Pattern.compile("[^{]+");
        private static final Pattern logOptionsRe = Pattern.compile("\\{[^}]+}");
        private static final Pattern configRe = Pattern.compile(String.format("^(%s)(%s)?$", logPatternRe.pattern(), logOptionsRe.pattern()));
        private static final Pattern msgRe = Pattern.compile("\\{m(?::(\\d+))?}");
        private static final Pattern headerRe = Pattern.compile("\\{h(?::(\\d+))?}");
        private static final Pattern bothRe = Pattern.compile("\\{h(?::(\\d+))?;m(?::(\\d+))?}");
        private final BinaryLog globalLog;
        private final Map<String, BinaryLog> perServiceLogs;
        private final Map<String, BinaryLog> perMethodLogs;

        @VisibleForTesting
        FactoryImpl(BinaryLogSink sink, String configurationString) {
            Preconditions.checkNotNull((Object)sink);
            Preconditions.checkState((configurationString != null && configurationString.length() > 0 ? 1 : 0) != 0);
            BinaryLog globalLog = null;
            HashMap<String, BinaryLog> perServiceLogs = new HashMap<String, BinaryLog>();
            HashMap<String, BinaryLog> perMethodLogs = new HashMap<String, BinaryLog>();
            for (String configuration : Splitter.on((char)',').split((CharSequence)configurationString)) {
                Matcher configMatcher = configRe.matcher(configuration);
                if (!configMatcher.matches()) {
                    throw new IllegalArgumentException("Bad input: " + configuration);
                }
                String methodOrSvc = configMatcher.group(1);
                String binlogOptionStr = configMatcher.group(2);
                BinaryLog binLog = FactoryImpl.createBinaryLog(sink, binlogOptionStr);
                if (binLog == null) continue;
                if (methodOrSvc.equals("*")) {
                    if (globalLog != null) {
                        logger.log(Level.SEVERE, "Ignoring duplicate entry: " + configuration);
                        continue;
                    }
                    globalLog = binLog;
                    logger.info("Global binlog: " + globalLog);
                    continue;
                }
                if (FactoryImpl.isServiceGlob(methodOrSvc)) {
                    String service = MethodDescriptor.extractFullServiceName((String)methodOrSvc);
                    if (perServiceLogs.containsKey(service)) {
                        logger.log(Level.SEVERE, "Ignoring duplicate entry: " + configuration);
                        continue;
                    }
                    perServiceLogs.put(service, binLog);
                    logger.info(String.format("Service binlog: service=%s log=%s", service, binLog));
                    continue;
                }
                if (perMethodLogs.containsKey(methodOrSvc)) {
                    logger.log(Level.SEVERE, "Ignoring duplicate entry: " + configuration);
                    continue;
                }
                perMethodLogs.put(methodOrSvc, binLog);
                logger.info(String.format("Method binlog: method=%s log=%s", methodOrSvc, binLog));
            }
            this.globalLog = globalLog;
            this.perServiceLogs = Collections.unmodifiableMap(perServiceLogs);
            this.perMethodLogs = Collections.unmodifiableMap(perMethodLogs);
        }

        @Override
        public BinaryLog getLog(String fullMethodName) {
            BinaryLog methodLog = this.perMethodLogs.get(fullMethodName);
            if (methodLog != null) {
                return methodLog;
            }
            BinaryLog serviceLog = this.perServiceLogs.get(MethodDescriptor.extractFullServiceName((String)fullMethodName));
            if (serviceLog != null) {
                return serviceLog;
            }
            return this.globalLog;
        }

        @Nullable
        @VisibleForTesting
        static BinaryLog createBinaryLog(BinaryLogSink sink, @Nullable String logConfig) {
            if (logConfig == null) {
                return new BinaryLog(new SinkWriterImpl(sink, Integer.MAX_VALUE, Integer.MAX_VALUE));
            }
            try {
                int maxMsgBytes;
                int maxHeaderBytes;
                Matcher headerMatcher = headerRe.matcher(logConfig);
                if (headerMatcher.matches()) {
                    String maxHeaderStr = headerMatcher.group(1);
                    maxHeaderBytes = maxHeaderStr != null ? Integer.parseInt(maxHeaderStr) : Integer.MAX_VALUE;
                    maxMsgBytes = 0;
                } else {
                    Matcher msgMatcher = msgRe.matcher(logConfig);
                    if (msgMatcher.matches()) {
                        maxHeaderBytes = 0;
                        String maxMsgStr = msgMatcher.group(1);
                        maxMsgBytes = maxMsgStr != null ? Integer.parseInt(maxMsgStr) : Integer.MAX_VALUE;
                    } else {
                        Matcher bothMatcher = bothRe.matcher(logConfig);
                        if (bothMatcher.matches()) {
                            String maxHeaderStr = bothMatcher.group(1);
                            String maxMsgStr = bothMatcher.group(2);
                            maxHeaderBytes = maxHeaderStr != null ? Integer.parseInt(maxHeaderStr) : Integer.MAX_VALUE;
                            maxMsgBytes = maxMsgStr != null ? Integer.parseInt(maxMsgStr) : Integer.MAX_VALUE;
                        } else {
                            logger.log(Level.SEVERE, "Illegal log config pattern: " + logConfig);
                            return null;
                        }
                    }
                }
                return new BinaryLog(new SinkWriterImpl(sink, maxHeaderBytes, maxMsgBytes));
            }
            catch (NumberFormatException e) {
                logger.log(Level.SEVERE, "Illegal log config pattern: " + logConfig);
                return null;
            }
        }

        static boolean isServiceGlob(String input) {
            return input.endsWith("/*");
        }
    }

    static interface Factory {
        @Nullable
        public BinaryLog getLog(String var1);
    }

    static abstract class SinkWriter {
        SinkWriter() {
        }

        abstract void logSendInitialMetadata(Metadata var1, boolean var2, BinaryLogProvider.CallId var3);

        abstract void logRecvInitialMetadata(Metadata var1, boolean var2, BinaryLogProvider.CallId var3, SocketAddress var4);

        abstract void logTrailingMetadata(Metadata var1, boolean var2, BinaryLogProvider.CallId var3);

        abstract <T> void logOutboundMessage(MethodDescriptor.Marshaller<T> var1, T var2, boolean var3, boolean var4, BinaryLogProvider.CallId var5);

        abstract <T> void logInboundMessage(MethodDescriptor.Marshaller<T> var1, T var2, boolean var3, boolean var4, BinaryLogProvider.CallId var5);

        abstract int getMaxHeaderBytes();

        abstract int getMaxMessageBytes();
    }

    static final class SinkWriterImpl
    extends SinkWriter {
        private final BinaryLogSink sink;
        private final int maxHeaderBytes;
        private final int maxMessageBytes;

        SinkWriterImpl(BinaryLogSink sink, int maxHeaderBytes, int maxMessageBytes) {
            this.sink = sink;
            this.maxHeaderBytes = maxHeaderBytes;
            this.maxMessageBytes = maxMessageBytes;
        }

        @Override
        void logSendInitialMetadata(Metadata metadata, boolean isServer, BinaryLogProvider.CallId callId) {
            GrpcLogEntry entry = GrpcLogEntry.newBuilder().setType(GrpcLogEntry.Type.SEND_INITIAL_METADATA).setLogger(isServer ? GrpcLogEntry.Logger.SERVER : GrpcLogEntry.Logger.CLIENT).setCallId(BinaryLog.callIdToProto(callId)).setMetadata(BinaryLog.metadataToProto(metadata, this.maxHeaderBytes)).build();
            this.sink.write((MessageLite)entry);
        }

        @Override
        void logRecvInitialMetadata(Metadata metadata, boolean isServer, BinaryLogProvider.CallId callId, SocketAddress peerSocket) {
            GrpcLogEntry entry = GrpcLogEntry.newBuilder().setType(GrpcLogEntry.Type.RECV_INITIAL_METADATA).setLogger(isServer ? GrpcLogEntry.Logger.SERVER : GrpcLogEntry.Logger.CLIENT).setCallId(BinaryLog.callIdToProto(callId)).setPeer(BinaryLog.socketToProto(peerSocket)).setMetadata(BinaryLog.metadataToProto(metadata, this.maxHeaderBytes)).build();
            this.sink.write((MessageLite)entry);
        }

        @Override
        void logTrailingMetadata(Metadata metadata, boolean isServer, BinaryLogProvider.CallId callId) {
            GrpcLogEntry entry = GrpcLogEntry.newBuilder().setType(isServer ? GrpcLogEntry.Type.SEND_TRAILING_METADATA : GrpcLogEntry.Type.RECV_TRAILING_METADATA).setLogger(isServer ? GrpcLogEntry.Logger.SERVER : GrpcLogEntry.Logger.CLIENT).setCallId(BinaryLog.callIdToProto(callId)).setMetadata(BinaryLog.metadataToProto(metadata, this.maxHeaderBytes)).build();
            this.sink.write((MessageLite)entry);
        }

        @Override
        <T> void logOutboundMessage(MethodDescriptor.Marshaller<T> marshaller, T message, boolean compressed, boolean isServer, BinaryLogProvider.CallId callId) {
            if (marshaller != BinaryLogProvider.BYTEARRAY_MARSHALLER) {
                throw new IllegalStateException("Expected the BinaryLog's ByteArrayMarshaller");
            }
            byte[] bytes = (byte[])message;
            GrpcLogEntry entry = GrpcLogEntry.newBuilder().setType(GrpcLogEntry.Type.SEND_MESSAGE).setLogger(isServer ? GrpcLogEntry.Logger.SERVER : GrpcLogEntry.Logger.CLIENT).setCallId(BinaryLog.callIdToProto(callId)).setMessage(BinaryLog.messageToProto(bytes, compressed, this.maxMessageBytes)).build();
            this.sink.write((MessageLite)entry);
        }

        @Override
        <T> void logInboundMessage(MethodDescriptor.Marshaller<T> marshaller, T message, boolean compressed, boolean isServer, BinaryLogProvider.CallId callId) {
            if (marshaller != BinaryLogProvider.BYTEARRAY_MARSHALLER) {
                throw new IllegalStateException("Expected the BinaryLog's ByteArrayMarshaller");
            }
            byte[] bytes = (byte[])message;
            GrpcLogEntry entry = GrpcLogEntry.newBuilder().setType(GrpcLogEntry.Type.RECV_MESSAGE).setLogger(isServer ? GrpcLogEntry.Logger.SERVER : GrpcLogEntry.Logger.CLIENT).setCallId(BinaryLog.callIdToProto(callId)).setMessage(BinaryLog.messageToProto(bytes, compressed, this.maxMessageBytes)).build();
            this.sink.write((MessageLite)entry);
        }

        @Override
        int getMaxHeaderBytes() {
            return this.maxHeaderBytes;
        }

        @Override
        int getMaxMessageBytes() {
            return this.maxMessageBytes;
        }
    }
}

