/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import io.grpc.ConnectivityState;
import io.grpc.Status;
import io.grpc.channelz.v1.Address;
import io.grpc.channelz.v1.Channel;
import io.grpc.channelz.v1.ChannelData;
import io.grpc.channelz.v1.ChannelRef;
import io.grpc.channelz.v1.GetServerSocketsResponse;
import io.grpc.channelz.v1.GetServersResponse;
import io.grpc.channelz.v1.GetTopChannelsResponse;
import io.grpc.channelz.v1.Server;
import io.grpc.channelz.v1.ServerData;
import io.grpc.channelz.v1.ServerRef;
import io.grpc.channelz.v1.Socket;
import io.grpc.channelz.v1.SocketData;
import io.grpc.channelz.v1.SocketOption;
import io.grpc.channelz.v1.SocketOptionLinger;
import io.grpc.channelz.v1.SocketOptionTcpInfo;
import io.grpc.channelz.v1.SocketOptionTimeout;
import io.grpc.channelz.v1.SocketRef;
import io.grpc.channelz.v1.Subchannel;
import io.grpc.channelz.v1.SubchannelRef;
import io.grpc.internal.Channelz;
import io.grpc.internal.Instrumented;
import io.grpc.internal.WithLogId;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

final class ChannelzProtoUtil {
    public static final String SO_LINGER = "SO_LINGER";
    public static final String SO_TIMEOUT = "SO_TIMEOUT";
    public static final String TCP_INFO = "TCP_INFO";

    private ChannelzProtoUtil() {
    }

    static ChannelRef toChannelRef(WithLogId obj) {
        return ChannelRef.newBuilder().setChannelId(obj.getLogId().getId()).setName(obj.toString()).build();
    }

    static SubchannelRef toSubchannelRef(WithLogId obj) {
        return SubchannelRef.newBuilder().setSubchannelId(obj.getLogId().getId()).setName(obj.toString()).build();
    }

    static ServerRef toServerRef(WithLogId obj) {
        return ServerRef.newBuilder().setServerId(obj.getLogId().getId()).setName(obj.toString()).build();
    }

    static SocketRef toSocketRef(WithLogId obj) {
        return SocketRef.newBuilder().setSocketId(obj.getLogId().getId()).setName(obj.toString()).build();
    }

    static Server toServer(Instrumented<Channelz.ServerStats> obj) {
        Channelz.ServerStats stats = (Channelz.ServerStats)ChannelzProtoUtil.getFuture(obj.getStats());
        Server.Builder builder = Server.newBuilder().setRef(ChannelzProtoUtil.toServerRef(obj)).setData(ChannelzProtoUtil.toServerData(stats));
        for (Instrumented listenSocket : stats.listenSockets) {
            builder.addListenSocket(ChannelzProtoUtil.toSocketRef((WithLogId)listenSocket));
        }
        return builder.build();
    }

    static ServerData toServerData(Channelz.ServerStats stats) {
        return ServerData.newBuilder().setCallsStarted(stats.callsStarted).setCallsSucceeded(stats.callsSucceeded).setCallsFailed(stats.callsFailed).setLastCallStartedTimestamp(Timestamps.fromMillis((long)stats.lastCallStartedMillis)).build();
    }

    static Socket toSocket(Instrumented<Channelz.SocketStats> obj) {
        Channelz.SocketStats socketStats = (Channelz.SocketStats)ChannelzProtoUtil.getFuture(obj.getStats());
        Socket.Builder builder = Socket.newBuilder().setRef(ChannelzProtoUtil.toSocketRef(obj)).setLocal(ChannelzProtoUtil.toAddress(socketStats.local));
        if (socketStats.remote != null) {
            builder.setRemote(ChannelzProtoUtil.toAddress(socketStats.remote));
        }
        builder.setData(ChannelzProtoUtil.extractSocketData(socketStats));
        return builder.build();
    }

    static Address toAddress(SocketAddress address) {
        Preconditions.checkNotNull((Object)address);
        Address.Builder builder = Address.newBuilder();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            builder.setTcpipAddress(Address.TcpIpAddress.newBuilder().setIpAddress(ByteString.copyFrom((byte[])inetAddress.getAddress().getAddress())).setPort(inetAddress.getPort()).build());
        } else if (address.getClass().getName().endsWith("io.netty.channel.unix.DomainSocketAddress")) {
            builder.setUdsAddress(Address.UdsAddress.newBuilder().setFilename(address.toString()).build());
        } else {
            builder.setOtherAddress(Address.OtherAddress.newBuilder().setName(address.toString()).build());
        }
        return builder.build();
    }

    static SocketData extractSocketData(Channelz.SocketStats socketStats) {
        SocketData.Builder builder = SocketData.newBuilder();
        if (socketStats.data != null) {
            Channelz.TransportStats s = socketStats.data;
            builder.setStreamsStarted(s.streamsStarted).setStreamsSucceeded(s.streamsSucceeded).setStreamsFailed(s.streamsFailed).setMessagesSent(s.messagesSent).setMessagesReceived(s.messagesReceived).setKeepAlivesSent(s.keepAlivesSent).setLastLocalStreamCreatedTimestamp(Timestamps.fromNanos((long)s.lastLocalStreamCreatedTimeNanos)).setLastRemoteStreamCreatedTimestamp(Timestamps.fromNanos((long)s.lastRemoteStreamCreatedTimeNanos)).setLastMessageSentTimestamp(Timestamps.fromNanos((long)s.lastMessageSentTimeNanos)).setLastMessageReceivedTimestamp(Timestamps.fromNanos((long)s.lastMessageReceivedTimeNanos)).setLocalFlowControlWindow(Int64Value.of((long)s.localFlowControlWindow)).setRemoteFlowControlWindow(Int64Value.of((long)s.remoteFlowControlWindow));
        }
        builder.addAllOption(ChannelzProtoUtil.toSocketOptionsList(socketStats.socketOptions));
        return builder.build();
    }

    static SocketOption toSocketOptionLinger(int lingerSeconds) {
        SocketOptionLinger lingerOpt = lingerSeconds >= 0 ? SocketOptionLinger.newBuilder().setActive(true).setDuration(Durations.fromSeconds((long)lingerSeconds)).build() : SocketOptionLinger.getDefaultInstance();
        return SocketOption.newBuilder().setName(SO_LINGER).setAdditional(Any.pack((Message)lingerOpt)).build();
    }

    static SocketOption toSocketOptionTimeout(String name, int timeoutMillis) {
        Preconditions.checkNotNull((Object)name);
        return SocketOption.newBuilder().setName(name).setAdditional(Any.pack((Message)SocketOptionTimeout.newBuilder().setDuration(Durations.fromMillis((long)timeoutMillis)).build())).build();
    }

    static SocketOption toSocketOptionTcpInfo(Channelz.TcpInfo i) {
        SocketOptionTcpInfo tcpInfo = SocketOptionTcpInfo.newBuilder().setTcpiState(i.state).setTcpiCaState(i.caState).setTcpiRetrans(i.retransmits).setTcpiProbes(i.probes).setTcpiBackoff(i.backoff).setTcpiOptions(i.options).setTcpiSndWscale(i.sndWscale).setTcpiRcvWscale(i.rcvWscale).setTcpiRto(i.rto).setTcpiAto(i.ato).setTcpiSndMss(i.sndMss).setTcpiRcvMss(i.rcvMss).setTcpiUnacked(i.unacked).setTcpiSacked(i.sacked).setTcpiLost(i.lost).setTcpiRetrans(i.retrans).setTcpiFackets(i.fackets).setTcpiLastDataSent(i.lastDataSent).setTcpiLastAckSent(i.lastAckSent).setTcpiLastDataRecv(i.lastDataRecv).setTcpiLastAckRecv(i.lastAckRecv).setTcpiPmtu(i.pmtu).setTcpiRcvSsthresh(i.rcvSsthresh).setTcpiRtt(i.rtt).setTcpiRttvar(i.rttvar).setTcpiSndSsthresh(i.sndSsthresh).setTcpiSndCwnd(i.sndCwnd).setTcpiAdvmss(i.advmss).setTcpiReordering(i.reordering).build();
        return SocketOption.newBuilder().setName(TCP_INFO).setAdditional(Any.pack((Message)tcpInfo)).build();
    }

    static SocketOption toSocketOptionAdditional(String name, String value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        return SocketOption.newBuilder().setName(name).setValue(value).build();
    }

    static List<SocketOption> toSocketOptionsList(Channelz.SocketOptions options) {
        Preconditions.checkNotNull((Object)options);
        ArrayList<SocketOption> ret = new ArrayList<SocketOption>();
        if (options.lingerSeconds != null) {
            ret.add(ChannelzProtoUtil.toSocketOptionLinger(options.lingerSeconds));
        }
        if (options.soTimeoutMillis != null) {
            ret.add(ChannelzProtoUtil.toSocketOptionTimeout(SO_TIMEOUT, options.soTimeoutMillis));
        }
        if (options.tcpInfo != null) {
            ret.add(ChannelzProtoUtil.toSocketOptionTcpInfo(options.tcpInfo));
        }
        for (Map.Entry entry : options.others.entrySet()) {
            ret.add(ChannelzProtoUtil.toSocketOptionAdditional((String)entry.getKey(), (String)entry.getValue()));
        }
        return ret;
    }

    static Channel toChannel(Instrumented<Channelz.ChannelStats> channel) {
        Channelz.ChannelStats stats = (Channelz.ChannelStats)ChannelzProtoUtil.getFuture(channel.getStats());
        Channel.Builder channelBuilder = Channel.newBuilder().setRef(ChannelzProtoUtil.toChannelRef(channel)).setData(ChannelzProtoUtil.extractChannelData(stats));
        for (WithLogId subchannel : stats.subchannels) {
            channelBuilder.addSubchannelRef(ChannelzProtoUtil.toSubchannelRef(subchannel));
        }
        return channelBuilder.build();
    }

    static ChannelData extractChannelData(Channelz.ChannelStats stats) {
        return ChannelData.newBuilder().setTarget(stats.target).setState(ChannelzProtoUtil.toState(stats.state)).setCallsStarted(stats.callsStarted).setCallsSucceeded(stats.callsSucceeded).setCallsFailed(stats.callsFailed).setLastCallStartedTimestamp(Timestamps.fromMillis((long)stats.lastCallStartedMillis)).build();
    }

    static ChannelData.State toState(ConnectivityState state) {
        if (state == null) {
            return ChannelData.State.UNKNOWN;
        }
        try {
            return Enum.valueOf(ChannelData.State.class, state.name());
        }
        catch (IllegalArgumentException e) {
            return ChannelData.State.UNKNOWN;
        }
    }

    static Subchannel toSubchannel(Instrumented<Channelz.ChannelStats> subchannel) {
        Channelz.ChannelStats stats = (Channelz.ChannelStats)ChannelzProtoUtil.getFuture(subchannel.getStats());
        Subchannel.Builder subchannelBuilder = Subchannel.newBuilder().setRef(ChannelzProtoUtil.toSubchannelRef(subchannel)).setData(ChannelzProtoUtil.extractChannelData(stats));
        Preconditions.checkState((stats.sockets.isEmpty() || stats.subchannels.isEmpty() ? 1 : 0) != 0);
        for (WithLogId childSocket : stats.sockets) {
            subchannelBuilder.addSocketRef(ChannelzProtoUtil.toSocketRef(childSocket));
        }
        for (WithLogId childSubchannel : stats.subchannels) {
            subchannelBuilder.addSubchannelRef(ChannelzProtoUtil.toSubchannelRef(childSubchannel));
        }
        return subchannelBuilder.build();
    }

    static GetTopChannelsResponse toGetTopChannelResponse(Channelz.RootChannelList rootChannels) {
        GetTopChannelsResponse.Builder responseBuilder = GetTopChannelsResponse.newBuilder().setEnd(rootChannels.end);
        for (Instrumented c : rootChannels.channels) {
            responseBuilder.addChannel(ChannelzProtoUtil.toChannel((Instrumented<Channelz.ChannelStats>)c));
        }
        return responseBuilder.build();
    }

    static GetServersResponse toGetServersResponse(Channelz.ServerList servers) {
        GetServersResponse.Builder responseBuilder = GetServersResponse.newBuilder().setEnd(servers.end);
        for (Instrumented s : servers.servers) {
            responseBuilder.addServer(ChannelzProtoUtil.toServer((Instrumented<Channelz.ServerStats>)s));
        }
        return responseBuilder.build();
    }

    static GetServerSocketsResponse toGetServerSocketsResponse(Channelz.ServerSocketsList serverSockets) {
        GetServerSocketsResponse.Builder responseBuilder = GetServerSocketsResponse.newBuilder().setEnd(serverSockets.end);
        for (WithLogId s : serverSockets.sockets) {
            responseBuilder.addSocketRef(ChannelzProtoUtil.toSocketRef(s));
        }
        return responseBuilder.build();
    }

    private static <T> T getFuture(ListenableFuture<T> future) {
        try {
            Object ret = future.get();
            if (ret == null) {
                throw Status.UNIMPLEMENTED.withDescription("The entity's stats can not be retrieved. If this is an InProcessTransport this is expected.").asRuntimeException();
            }
            return (T)ret;
        }
        catch (InterruptedException e) {
            throw Status.INTERNAL.withCause((Throwable)e).asRuntimeException();
        }
        catch (ExecutionException e) {
            throw Status.INTERNAL.withCause((Throwable)e).asRuntimeException();
        }
    }
}

