/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import com.google.common.base.Objects;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.net.HttpCookie;
import java.util.logging.Level;
import java.util.logging.Logger;

final class RequireDoubleSubmitCookieInterceptor
implements ServerInterceptor {
    private static final Logger log = Logger.getLogger(RequireDoubleSubmitCookieInterceptor.class.getName());
    static final Metadata.Key<String> COOKIE = Metadata.Key.of((String)"cookie", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    static final ServerCall.Listener NOOP = new ServerCall.Listener(){};
    private final String tokenName;
    private final Metadata.Key<String> headerKey;
    private final Status failStatus;

    RequireDoubleSubmitCookieInterceptor(String tokenName) {
        this.tokenName = tokenName;
        this.headerKey = Metadata.Key.of((String)tokenName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        this.failStatus = Status.FAILED_PRECONDITION.withDescription(String.format("Double submit cookie failure. There must be both a cookie and metadata with matching values, for XSRF protection. The cookie and metadata keys must both be: %s", tokenName));
    }

    private <ReqT, RespT> ServerCall.Listener<ReqT> failCall(ServerCall<ReqT, RespT> call) {
        call.close(this.failStatus, new Metadata());
        return NOOP;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        String xsrfCookie = null;
        Iterable cookieHeaders = headers.getAll(COOKIE);
        if (cookieHeaders == null) {
            return this.failCall(call);
        }
        for (String cookieHeader : cookieHeaders) {
            try {
                for (HttpCookie cookie : HttpCookie.parse(cookieHeader)) {
                    if (!cookie.getName().equals(this.tokenName)) continue;
                    if (xsrfCookie == null) {
                        xsrfCookie = cookie.getValue();
                        continue;
                    }
                    log.log(Level.FINE, "Multiple cookies set for {}, this is not allowed", this.tokenName);
                    return this.failCall(call);
                }
            }
            catch (IllegalArgumentException e) {
                log.log(Level.FINE, "Failed to parse cookie header", e);
                return this.failCall(call);
            }
        }
        String xsrfHeader = (String)headers.get(this.headerKey);
        if (xsrfCookie == null || !Objects.equal(xsrfCookie, (Object)xsrfHeader)) {
            return this.failCall(call);
        }
        return next.startCall(call, headers);
    }
}

