/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class HealthServiceImpl
extends HealthGrpc.HealthImplBase {
    private final ConcurrentHashMap<String, HealthCheckResponse.ServingStatus> statusMap = new ConcurrentHashMap();
    private final Object watchLock = new Object();
    @GuardedBy(value="watchLock")
    private final HashMap<String, IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean>> watchers = new HashMap();

    HealthServiceImpl() {
    }

    @Override
    public void check(HealthCheckRequest request, StreamObserver<HealthCheckResponse> responseObserver) {
        HealthCheckResponse.ServingStatus status = this.statusMap.get(request.getService());
        if (status == null) {
            responseObserver.onError((Throwable)new StatusException(Status.NOT_FOUND.withDescription("unknown service " + request.getService())));
        } else {
            HealthCheckResponse response = HealthCheckResponse.newBuilder().setStatus(status).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watch(HealthCheckRequest request, final StreamObserver<HealthCheckResponse> responseObserver) {
        final String service = request.getService();
        Object object = this.watchLock;
        synchronized (object) {
            HealthCheckResponse.ServingStatus status = this.statusMap.get(service);
            responseObserver.onNext((Object)HealthServiceImpl.getResponseForWatch(status));
            IdentityHashMap<Object, Boolean> serviceWatchers = this.watchers.get(service);
            if (serviceWatchers == null) {
                serviceWatchers = new IdentityHashMap();
                this.watchers.put(service, serviceWatchers);
            }
            serviceWatchers.put(responseObserver, Boolean.TRUE);
        }
        Context.current().addListener(new Context.CancellationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cancelled(Context context) {
                Object object = HealthServiceImpl.this.watchLock;
                synchronized (object) {
                    IdentityHashMap serviceWatchers = (IdentityHashMap)HealthServiceImpl.this.watchers.get(service);
                    if (serviceWatchers != null) {
                        serviceWatchers.remove(responseObserver);
                        if (serviceWatchers.isEmpty()) {
                            HealthServiceImpl.this.watchers.remove(service);
                        }
                    }
                }
            }
        }, MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatus(String service, HealthCheckResponse.ServingStatus status) {
        Object object = this.watchLock;
        synchronized (object) {
            HealthCheckResponse.ServingStatus prevStatus = this.statusMap.put(service, status);
            if (prevStatus != status) {
                this.notifyWatchers(service, status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearStatus(String service) {
        Object object = this.watchLock;
        synchronized (object) {
            HealthCheckResponse.ServingStatus prevStatus = this.statusMap.remove(service);
            if (prevStatus != null) {
                this.notifyWatchers(service, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int numWatchersForTest(String service) {
        Object object = this.watchLock;
        synchronized (object) {
            IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean> serviceWatchers = this.watchers.get(service);
            if (serviceWatchers == null) {
                return 0;
            }
            return serviceWatchers.size();
        }
    }

    @GuardedBy(value="watchLock")
    private void notifyWatchers(String service, @Nullable HealthCheckResponse.ServingStatus status) {
        HealthCheckResponse response = HealthServiceImpl.getResponseForWatch(status);
        IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean> serviceWatchers = this.watchers.get(service);
        if (serviceWatchers != null) {
            for (StreamObserver<HealthCheckResponse> responseObserver : serviceWatchers.keySet()) {
                responseObserver.onNext((Object)response);
            }
        }
    }

    private static HealthCheckResponse getResponseForWatch(@Nullable HealthCheckResponse.ServingStatus recordedStatus) {
        return HealthCheckResponse.newBuilder().setStatus(recordedStatus == null ? HealthCheckResponse.ServingStatus.SERVICE_UNKNOWN : recordedStatus).build();
    }
}

