/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.services.HealthCheckingLoadBalancerUtil;

@Internal
public final class HealthCheckingRoundRobinLoadBalancerProvider
extends LoadBalancerProvider {
    private final LoadBalancerProvider rrProvider = HealthCheckingRoundRobinLoadBalancerProvider.newRoundRobinProvider();

    public boolean isAvailable() {
        return this.rrProvider.isAvailable();
    }

    public int getPriority() {
        return this.rrProvider.getPriority() + 1;
    }

    public String getPolicyName() {
        return this.rrProvider.getPolicyName();
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return HealthCheckingLoadBalancerUtil.newHealthCheckingLoadBalancer((LoadBalancer.Factory)this.rrProvider, helper);
    }

    @VisibleForTesting
    static LoadBalancerProvider newRoundRobinProvider() {
        try {
            Class<?> rrProviderClass = Class.forName("io.grpc.util.SecretRoundRobinLoadBalancerProvider$Provider");
            return (LoadBalancerProvider)rrProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

