/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

final class HealthServiceImpl
extends HealthGrpc.HealthImplBase {
    private final Map<String, HealthCheckResponse.ServingStatus> statusMap = new ConcurrentHashMap<String, HealthCheckResponse.ServingStatus>();

    HealthServiceImpl() {
    }

    @Override
    public void check(HealthCheckRequest request, StreamObserver<HealthCheckResponse> responseObserver) {
        HealthCheckResponse.ServingStatus status = this.getStatus(request.getService());
        if (status == null) {
            responseObserver.onError((Throwable)new StatusException(Status.NOT_FOUND));
        } else {
            HealthCheckResponse response = HealthCheckResponse.newBuilder().setStatus(status).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }

    void setStatus(String service, HealthCheckResponse.ServingStatus status) {
        this.statusMap.put(service, status);
    }

    @Nullable
    HealthCheckResponse.ServingStatus getStatus(String service) {
        return this.statusMap.get(service);
    }

    void clearStatus(String service) {
        this.statusMap.remove(service);
    }
}

