/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.instrumentation.stats.RpcConstants;
import com.google.instrumentation.stats.Stats;
import com.google.instrumentation.stats.StatsManager;
import com.google.instrumentation.stats.ViewDescriptor;
import com.google.protobuf.Empty;
import io.grpc.instrumentation.v1alpha.CanonicalRpcStats;
import io.grpc.instrumentation.v1alpha.MonitoringGrpc;
import io.grpc.services.MonitoringUtil;
import io.grpc.stub.StreamObserver;

public final class MonitoringService
extends MonitoringGrpc.MonitoringImplBase {
    private static MonitoringService instance;
    private final StatsManager statsManager;

    @VisibleForTesting
    MonitoringService(StatsManager statsManager) {
        Preconditions.checkNotNull((Object)statsManager, (Object)"StatsManager implementation unavailable");
        this.statsManager = statsManager;
    }

    public static synchronized MonitoringService getInstance() {
        if (instance == null) {
            instance = new MonitoringService(Stats.getStatsManager());
        }
        return instance;
    }

    @Override
    public void getCanonicalRpcStats(Empty request, StreamObserver<CanonicalRpcStats> responseObserver) {
        CanonicalRpcStats response = CanonicalRpcStats.newBuilder().setRpcClientElapsedTime(MonitoringUtil.buildCanonicalRpcStatsView(this.statsManager.getView((ViewDescriptor)RpcConstants.RPC_CLIENT_ROUNDTRIP_LATENCY_VIEW))).setRpcClientServerElapsedTime(MonitoringUtil.buildCanonicalRpcStatsView(this.statsManager.getView((ViewDescriptor)RpcConstants.RPC_CLIENT_SERVER_ELAPSED_TIME_VIEW))).setRpcClientRequestBytes(MonitoringUtil.buildCanonicalRpcStatsView(this.statsManager.getView((ViewDescriptor)RpcConstants.RPC_CLIENT_REQUEST_BYTES_VIEW))).setRpcClientResponseBytes(MonitoringUtil.buildCanonicalRpcStatsView(this.statsManager.getView((ViewDescriptor)RpcConstants.RPC_CLIENT_RESPONSE_BYTES_VIEW))).setRpcServerServerElapsedTime(MonitoringUtil.buildCanonicalRpcStatsView(this.statsManager.getView((ViewDescriptor)RpcConstants.RPC_SERVER_SERVER_LATENCY_VIEW))).setRpcServerRequestBytes(MonitoringUtil.buildCanonicalRpcStatsView(this.statsManager.getView((ViewDescriptor)RpcConstants.RPC_SERVER_REQUEST_BYTES_VIEW))).setRpcServerResponseBytes(MonitoringUtil.buildCanonicalRpcStatsView(this.statsManager.getView((ViewDescriptor)RpcConstants.RPC_SERVER_RESPONSE_BYTES_VIEW))).setRpcServerElapsedTime(MonitoringUtil.buildCanonicalRpcStatsView(this.statsManager.getView((ViewDescriptor)RpcConstants.RPC_SERVER_SERVER_ELAPSED_TIME_VIEW))).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }
}

