/*
 * Decompiled with CFR 0.152.
 */
package io.helixservice.core.server;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import io.helixservice.core.component.Component;
import io.helixservice.core.feature.Feature;
import io.helixservice.core.server.Server;
import io.helixservice.core.server.ServerState;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixServer
implements Server {
    private static final Logger LOG = LoggerFactory.getLogger(HelixServer.class);
    private final Supplier<Feature[]> bootstrapFeaturesSupplier;
    private final Supplier<Feature[]> coreFeaturesSupplier;
    private Multimap<String, Component> registrationMap = ArrayListMultimap.create();
    private ServerState serverState = ServerState.STOPPED;
    private boolean bootstrapFeaturesStarted = false;
    private List<Feature> bootstrapFeatures;
    private List<Feature> coreFeatures;
    private List<Feature> features;
    private Vertx vertx;

    public HelixServer(Supplier<Feature[]> bootstrapFeaturesSupplier, Supplier<Feature[]> coreFeaturesSupplier) {
        this.bootstrapFeaturesSupplier = bootstrapFeaturesSupplier;
        this.coreFeaturesSupplier = coreFeaturesSupplier;
    }

    @Override
    public Optional<Vertx> getVertx() {
        return Optional.ofNullable(this.vertx);
    }

    @Override
    public ServerState getServerState() {
        return this.serverState;
    }

    @Override
    public List<Feature> getFeatures() {
        return this.features;
    }

    @Override
    public Thread start() {
        if (this.serverState != ServerState.STOPPED) {
            throw new IllegalStateException("Server state must be STOPPED in order to start the server");
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                HelixServer.this.serverState = ServerState.STARTING;
                LOG.info("Starting Helix Server");
                HelixServer.this.instantiateFeatures();
                for (Feature feature : HelixServer.this.features) {
                    feature.logFeatureDetails(LOG);
                    Multimap<String, Component> registrationMap = feature.getRegistrationMap();
                    HelixServer.this.registrationMap.putAll(registrationMap);
                }
                if (!HelixServer.this.bootstrapFeaturesStarted) {
                    for (Feature bootstrapFeature : HelixServer.this.bootstrapFeatures) {
                        bootstrapFeature.start(HelixServer.this);
                    }
                    HelixServer.this.bootstrapFeaturesStarted = true;
                }
                String numWorkers = System.getProperty("vertx.server.workers", "50");
                VertxOptions options = new VertxOptions().setWorkerPoolSize(Integer.parseInt(numWorkers));
                HelixServer.this.vertx = Vertx.vertx((VertxOptions)options);
                for (Feature coreFeature : HelixServer.this.coreFeatures) {
                    coreFeature.start(HelixServer.this);
                }
                HelixServer.this.serverState = ServerState.STARTED;
                LOG.info("Helix Server started in " + (System.currentTimeMillis() - start) + " ms");
            }
        });
        thread.start();
        return thread;
    }

    @Override
    public Thread restart() {
        if (this.serverState != ServerState.STARTED) {
            throw new IllegalStateException("Server state must be STARTED in order to restart the server");
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.info("Restarting Helix Server");
                try {
                    HelixServer.this.stop(false).join();
                    HelixServer.this.start().join();
                }
                catch (InterruptedException e) {
                    LOG.error("Restart HelixServer interrupted ", (Throwable)e);
                }
            }
        });
        thread.start();
        return thread;
    }

    private void instantiateFeatures() {
        this.features = new ArrayList<Feature>();
        if (this.bootstrapFeatures == null) {
            this.bootstrapFeatures = Arrays.asList((Object[])this.bootstrapFeaturesSupplier.get());
            this.features.addAll(this.bootstrapFeatures);
        }
        this.coreFeatures = Arrays.asList((Object[])this.coreFeaturesSupplier.get());
        this.features.addAll(this.coreFeatures);
    }

    @Override
    public Thread stop(final boolean immediate) {
        if (this.serverState != ServerState.STARTED) {
            throw new IllegalStateException("Server state must be STARTED in order to stop the server");
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList reverseStartOrder = new ArrayList(HelixServer.this.features);
                Collections.reverse(reverseStartOrder);
                HelixServer.this.serverState = ServerState.FINISHING;
                LOG.info("Finishing Helix Server");
                for (Feature feature : reverseStartOrder) {
                    feature.finish(HelixServer.this);
                }
                if (!immediate) {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                LOG.info("Stopping Helix Server");
                HelixServer.this.serverState = ServerState.STOPPING;
                HelixServer.this.vertx.close(r -> {
                    for (Feature feature : reverseStartOrder) {
                        feature.stop(HelixServer.this);
                    }
                    HelixServer.this.registrationMap.clear();
                    HelixServer.this.vertx = null;
                    HelixServer.this.serverState = ServerState.STOPPED;
                    HelixServer.this.features = null;
                    HelixServer.this.bootstrapFeatures = null;
                    HelixServer.this.coreFeatures = null;
                    LOG.info("Stopped Helix Server");
                });
            }
        });
        thread.start();
        return thread;
    }

    @Override
    public Multimap<String, Component> getRegistrationMap() {
        return ArrayListMultimap.create(this.registrationMap);
    }

    @Override
    public <T extends Component> Collection<T> findByType(String componentType) {
        List result = this.registrationMap.get((Object)componentType);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public <T extends Component> T findByType(String componentType, T defaultValue) {
        return (T)((Component)Iterables.getFirst((Iterable)this.registrationMap.get((Object)componentType), defaultValue));
    }
}

