/*
 * Decompiled with CFR 0.152.
 */
package io.helixservice.feature.vertx;

import io.helixservice.core.feature.AbstractFeature;
import io.helixservice.core.server.Server;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class VertxNativeFeature
extends AbstractFeature {
    public static final String DEFAULT_HTTPCLIENT_NAME = "DefaultHttpClient";
    private Map<String, HttpClient> httpClientMap = new ConcurrentHashMap<String, HttpClient>();
    private Vertx vertx;

    @Override
    public void start(Server server) {
        this.vertx = server.getVertx().get();
    }

    @Override
    public void stop(Server server) {
        this.closeHttpClients();
        this.vertx = null;
    }

    private void closeHttpClients() {
        this.httpClientMap.values().forEach(HttpClient::close);
        this.httpClientMap.clear();
    }

    public Supplier<HttpClient> httpClient() {
        return this.httpClient(DEFAULT_HTTPCLIENT_NAME);
    }

    public Supplier<HttpClient> httpClient(String httpClientName) {
        return () -> this.httpClientMap.computeIfAbsent(httpClientName, key -> this.vertx().createHttpClient());
    }

    public Supplier<HttpClient> httpClient(String httpClientName, HttpClientOptions httpClientOptions) {
        return () -> this.httpClientMap.computeIfAbsent(httpClientName, key -> this.vertx().createHttpClient(httpClientOptions));
    }

    private Vertx vertx() {
        this.checkInitialized();
        return this.vertx;
    }

    private Vertx checkInitialized() {
        return Objects.requireNonNull(this.vertx, "Vert.x native feature has not been initialized");
    }
}

