/*
 * Decompiled with CFR 0.152.
 */
package io.helixservice.core.feature;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import io.helixservice.core.component.Component;
import io.helixservice.core.feature.Feature;
import io.helixservice.core.server.Server;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public abstract class AbstractFeature
implements Feature {
    private Multimap<String, Component> registrationMap = ArrayListMultimap.create();
    private String featureName;

    public AbstractFeature() {
        this.featureName = this.getClass().getSimpleName();
    }

    public AbstractFeature(String featureName) {
        this.featureName = featureName;
    }

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    public void register(Component ... componentArray) {
        for (Component component : componentArray) {
            this.registrationMap.put((Object)component.getComponentType(), (Object)component);
            this.register(component.getContainedComponents());
        }
    }

    @Override
    public Multimap<String, Component> getRegistrationMap() {
        return ArrayListMultimap.create(this.registrationMap);
    }

    @Override
    public <T extends Component> Collection<T> findByType(String componentType) {
        List result = this.registrationMap.get((Object)componentType);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public <T extends Component> T findByType(String componentType, T defaultValue) {
        return (T)((Component)Iterables.getLast((Iterable)this.registrationMap.get((Object)componentType), defaultValue));
    }

    @Override
    public void logFeatureDetails(Logger logger) {
        logger.info("Feature " + this.getFeatureName() + " components:");
        this.logFactories(logger);
        this.logComponents(logger);
    }

    private void logComponents(Logger logger) {
        ArrayList<String> componentDescriptions = new ArrayList<String>();
        for (String registrableTypeName : this.registrationMap.keySet()) {
            for (Component component : this.registrationMap.get((Object)registrableTypeName)) {
                String componentDescription = component.getComponentDescription();
                if (componentDescription == null || componentDescription.isEmpty()) continue;
                componentDescriptions.add("   " + String.format("%1$-15s", registrableTypeName) + " " + componentDescription);
            }
        }
        Collections.sort(componentDescriptions);
        componentDescriptions.forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }

    private void logFactories(Logger logger) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = this.getClass().getDeclaredMethods()) {
            if ("void".equals(method.getGenericReturnType().getTypeName()) || (method.getModifiers() & 1) == 0) continue;
            logger.info("   {}  {}", (Object)String.format("%1$-15s", "FactoryMethod"), (Object)(method.getName() + "() => " + method.getGenericReturnType().getTypeName()));
        }
    }

    @Override
    public void start(Server server) {
    }

    @Override
    public void finish(Server server) {
    }

    @Override
    public void stop(Server server) {
    }
}

