/*
 * Decompiled with CFR 0.152.
 */
package io.jdev.miniprofiler.jooq;

import io.jdev.miniprofiler.ProfilerProvider;
import io.jdev.miniprofiler.jooq.MiniProfilerJooqUtil;
import org.jooq.ExecuteContext;
import org.jooq.impl.DefaultExecuteListener;

public class MiniProfilerExecuteListener
extends DefaultExecuteListener {
    protected final ProfilerProvider provider;
    private long start;

    public MiniProfilerExecuteListener(ProfilerProvider provider) {
        this.provider = provider;
    }

    public void start(ExecuteContext ctx) {
        this.start = System.currentTimeMillis();
    }

    public void end(ExecuteContext ctx) {
        if (this.provider.hasCurrent()) {
            long duration = System.currentTimeMillis() - this.start;
            this.maybeAddTiming(ctx, duration);
        }
    }

    protected void maybeAddTiming(ExecuteContext ctx, long duration) {
        String query = MiniProfilerJooqUtil.renderInlined(ctx);
        if (query != null) {
            this.addTiming(ctx, query, duration);
        }
    }

    protected void addTiming(ExecuteContext ctx, String query, long duration) {
        this.provider.current().addCustomTiming("sql", "query", query, duration);
    }
}

