/*
 * Decompiled with CFR 0.152.
 */
package io.jdev.miniprofiler.jooq;

import io.jdev.miniprofiler.ProfilerProvider;
import org.jooq.Configuration;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteType;
import org.jooq.QueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.tools.StringUtils;

public class MiniProfilerExecuteListener
extends DefaultExecuteListener {
    private final ProfilerProvider provider;
    private long start;

    public MiniProfilerExecuteListener(ProfilerProvider provider) {
        this.provider = provider;
    }

    public void start(ExecuteContext ctx) {
        this.start = System.currentTimeMillis();
    }

    public void end(ExecuteContext ctx) {
        if (this.provider.hasCurrent()) {
            long duration = System.currentTimeMillis() - this.start;
            this.addTiming(ctx, duration);
        }
    }

    private void addTiming(ExecuteContext ctx, long duration) {
        String[] statements;
        Configuration configuration = ctx.configuration();
        String query = null;
        if (ctx.query() != null) {
            query = DSL.using((Configuration)configuration).renderInlined((QueryPart)ctx.query());
        } else if (ctx.routine() != null) {
            query = DSL.using((Configuration)configuration).renderInlined((QueryPart)ctx.routine());
        } else if (!StringUtils.isBlank((String)ctx.sql())) {
            query = ctx.sql();
        } else if (ctx.type() == ExecuteType.BATCH && (statements = ctx.batchSQL()) != null && statements.length > 0) {
            StringBuilder queries = new StringBuilder();
            for (String sql : statements) {
                if (queries.length() > 0) {
                    queries.append(";\n");
                }
                queries.append(sql);
            }
            query = queries.toString();
        }
        if (query != null) {
            this.provider.current().addCustomTiming("sql", "query", query, duration);
        }
    }
}

