/*
 * Decompiled with CFR 0.152.
 */
package io.johnsonlee.tracing.runtime;

import android.os.SystemClock;
import android.util.Printer;
import io.johnsonlee.tracing.runtime.LooperProfiler;
import io.johnsonlee.tracing.runtime.LooperProfilerKt;
import io.johnsonlee.tracing.util.LooperUtil;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B;\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012 \b\u0002\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ \u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\tH\u0014J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\tR&\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/johnsonlee/tracing/runtime/LooperProfiler;", "Landroid/util/Printer;", "threshold", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "callback", "Lkotlin/Function3;", "", "", "", "(JLjava/util/concurrent/TimeUnit;Lkotlin/jvm/functions/Function3;)V", "ts", "what", "onEachLoop", "duration", "message", "println", "runtime_release"})
public class LooperProfiler
implements Printer {
    private long ts;
    private int what;
    private final Function3<Integer, Long, String, Unit> callback;

    protected void onEachLoop(int what, long duration, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.callback.invoke((Object)what, (Object)duration, (Object)message);
    }

    public final void println(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (StringsKt.startsWith$default((String)message, (String)">>>>> Dispatching to ", (boolean)false, (int)2, null)) {
            this.ts = SystemClock.elapsedRealtimeNanos();
            this.what = LooperUtil.findWhat((String)message);
        } else if (StringsKt.startsWith$default((String)message, (String)"<<<<< Finished to ", (boolean)false, (int)2, null)) {
            this.onEachLoop(this.what, SystemClock.elapsedRealtimeNanos() - this.ts, message);
        }
    }

    public LooperProfiler(long threshold, @NotNull TimeUnit timeUnit, @NotNull Function3<? super Integer, ? super Long, ? super String, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.callback = callback;
    }

    public /* synthetic */ LooperProfiler(final long l, final TimeUnit timeUnit, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 200L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        if ((n & 4) != 0) {
            function3 = (Function3)new Function3<Integer, Long, String, Unit>(){

                public final void invoke(int what, long duration, @NotNull String message) {
                    String string;
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    Function2 log2 = duration >= TimeUnit.NANOSECONDS.convert(l, timeUnit) ? (Function2)log.1.INSTANCE : (Function2)log.2.INSTANCE;
                    String string2 = "%8d";
                    Object[] objectArray = new Object[]{timeUnit.convert(duration, TimeUnit.NANOSECONDS)};
                    StringBuilder stringBuilder = new StringBuilder().append('[');
                    String string3 = "LooperProfiler";
                    Function2 function2 = log2;
                    boolean bl = false;
                    String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(this, *args)");
                    String string5 = string4;
                    string2 = "%4d";
                    objectArray = new Object[]{what};
                    stringBuilder = stringBuilder.append(string5).append(LooperProfilerKt.access$getTIME_UNIT_SYMBOLS$p()[timeUnit.ordinal()]).append("] ");
                    bl = false;
                    String string6 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(this, *args)");
                    string5 = string6;
                    StringBuilder stringBuilder2 = stringBuilder.append(string5).append(" : ");
                    String string7 = LooperUtil.findCallback((String)message);
                    if (string7 == null) {
                        string7 = string = LooperUtil.findHandler((String)message);
                    }
                    if (string7 == null) {
                        string = message;
                    }
                    function2.invoke((Object)string3, (Object)stringBuilder2.append(string).toString());
                }
            };
        }
        this(l, timeUnit, (Function3<? super Integer, ? super Long, ? super String, Unit>)function3);
    }

    public LooperProfiler() {
        this(0L, null, null, 7, null);
    }
}

