/*
 * Decompiled with CFR 0.152.
 */
package io.kgraph.tools.importer;

import io.kgraph.utils.GraphUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import picocli.CommandLine;

@CommandLine.Command(description={"Imports a Kafka graph."}, name="graph-import", mixinStandardHelpOptions=true, version={"graph-import 1.0"})
public class GraphImporter
implements Callable<Void> {
    @CommandLine.Parameters(index="0", description={"List of Kafka servers."})
    private String bootstrapServers;
    @CommandLine.Parameters(index="1", description={"The vertices file."})
    private File verticesFile;
    @CommandLine.Parameters(index="2", description={"The edges file."})
    private File edgesFile;
    @CommandLine.Parameters(index="3", description={"The vertices topic."})
    private String verticesTopic;
    @CommandLine.Parameters(index="4", description={"The edges topic."})
    private String edgesTopic;
    @CommandLine.Option(names={"-d", "--double"}, description={"Whether values are of type double or long."})
    private boolean valuesOfTypeDouble = false;
    @CommandLine.Option(names={"-np", "--numPartitions"}, description={"The number of partitions for topics."})
    private int numPartitions = 50;
    @CommandLine.Option(names={"-rf", "--replicationFactor"}, description={"The replication factor for topics."})
    private short replicationFactor = 1;

    public GraphImporter() {
    }

    public GraphImporter(String bootstrapServers, File verticesFile, File edgesFile, String verticesTopic, String edgesTopic, boolean valuesOfTypeDouble, int numPartitions, short replicationFactor) {
        this.bootstrapServers = bootstrapServers;
        this.verticesFile = verticesFile;
        this.edgesFile = edgesFile;
        this.verticesTopic = verticesTopic;
        this.edgesTopic = edgesTopic;
        this.valuesOfTypeDouble = valuesOfTypeDouble;
        this.numPartitions = numPartitions;
        this.replicationFactor = replicationFactor;
    }

    @Override
    public Void call() throws Exception {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", this.bootstrapServers);
        if (this.valuesOfTypeDouble) {
            GraphUtils.verticesToTopic((InputStream)new BufferedInputStream(new FileInputStream(this.verticesFile)), Double::parseDouble, (Serializer)new DoubleSerializer(), (Properties)props, (String)this.verticesTopic, (int)this.numPartitions, (short)this.replicationFactor);
            GraphUtils.edgesToTopic((InputStream)new BufferedInputStream(new FileInputStream(this.edgesFile)), Double::parseDouble, (Serializer)new DoubleSerializer(), (Properties)props, (String)this.edgesTopic, (int)this.numPartitions, (short)this.replicationFactor);
        } else {
            GraphUtils.verticesToTopic((InputStream)new BufferedInputStream(new FileInputStream(this.verticesFile)), Long::parseLong, (Serializer)new LongSerializer(), (Properties)props, (String)this.verticesTopic, (int)this.numPartitions, (short)this.replicationFactor);
            GraphUtils.edgesToTopic((InputStream)new BufferedInputStream(new FileInputStream(this.edgesFile)), Long::parseLong, (Serializer)new LongSerializer(), (Properties)props, (String)this.edgesTopic, (int)this.numPartitions, (short)this.replicationFactor);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        CommandLine.call((Callable)new GraphImporter(), (String[])args);
    }
}

