/*
 * Decompiled with CFR 0.152.
 */
package io.klogging;

import io.klogging.config.KloggingConfiguration;
import io.klogging.events.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lio/klogging/BaseLogger;", "", "name", "", "getName", "()Ljava/lang/String;", "isDebugEnabled", "", "isErrorEnabled", "isFatalEnabled", "isInfoEnabled", "isLevelEnabled", "level", "Lio/klogging/events/Level;", "isTraceEnabled", "isWarnEnabled", "minLevel", "klogging"})
public interface BaseLogger {
    @NotNull
    public String getName();

    @NotNull
    public Level minLevel();

    public boolean isLevelEnabled(@NotNull Level var1);

    public boolean isTraceEnabled();

    public boolean isDebugEnabled();

    public boolean isInfoEnabled();

    public boolean isWarnEnabled();

    public boolean isErrorEnabled();

    public boolean isFatalEnabled();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Level minLevel(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return KloggingConfiguration.INSTANCE.minimumLevelOf(this_.getName());
        }

        public static boolean isLevelEnabled(@NotNull BaseLogger this_, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            return this_.minLevel().compareTo((Enum)level) <= 0;
        }

        public static boolean isTraceEnabled(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.minLevel().compareTo((Enum)Level.TRACE) <= 0;
        }

        public static boolean isDebugEnabled(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.minLevel().compareTo((Enum)Level.DEBUG) <= 0;
        }

        public static boolean isInfoEnabled(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.minLevel().compareTo((Enum)Level.INFO) <= 0;
        }

        public static boolean isWarnEnabled(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.minLevel().compareTo((Enum)Level.WARN) <= 0;
        }

        public static boolean isErrorEnabled(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.minLevel().compareTo((Enum)Level.ERROR) <= 0;
        }

        public static boolean isFatalEnabled(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.minLevel().compareTo((Enum)Level.FATAL) <= 0;
        }
    }
}

