/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.config;

import io.klogging.config.ConfigDsl;
import io.klogging.config.LevelRange;
import io.klogging.events.Level;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00130\u0017\u00a2\u0006\u0002\b\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0004H\u0007J)\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00152\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00130\u0017\u00a2\u0006\u0002\b\u0018H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lio/klogging/config/LoggingConfig;", "", "()V", "matchAllLoggers", "", "getMatchAllLoggers$klogging", "()Ljava/lang/String;", "nameMatch", "Lkotlin/text/Regex;", "getNameMatch$klogging", "()Lkotlin/text/Regex;", "setNameMatch$klogging", "(Lkotlin/text/Regex;)V", "ranges", "", "Lio/klogging/config/LevelRange;", "getRanges$klogging", "()Ljava/util/List;", "atLevel", "", "level", "Lio/klogging/events/Level;", "configBlock", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "exactLogger", "exactName", "fromLoggerBase", "baseName", "fromMinLevel", "minLevel", "klogging"})
public final class LoggingConfig {
    @NotNull
    private final String matchAllLoggers;
    @NotNull
    private Regex nameMatch;
    @NotNull
    private final List<LevelRange> ranges;

    public LoggingConfig() {
        this.matchAllLoggers = ".*";
        this.nameMatch = new Regex(this.matchAllLoggers);
        boolean bl = false;
        this.ranges = new ArrayList();
    }

    @NotNull
    public final String getMatchAllLoggers$klogging() {
        return this.matchAllLoggers;
    }

    @NotNull
    public final Regex getNameMatch$klogging() {
        return this.nameMatch;
    }

    public final void setNameMatch$klogging(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"<set-?>");
        this.nameMatch = regex;
    }

    @NotNull
    public final List<LevelRange> getRanges$klogging() {
        return this.ranges;
    }

    @ConfigDsl
    public final void fromLoggerBase(@NotNull String baseName) {
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        this.nameMatch = new Regex("^" + baseName + ".*");
    }

    @ConfigDsl
    public final void exactLogger(@NotNull String exactName) {
        Intrinsics.checkNotNullParameter((Object)exactName, (String)"exactName");
        this.nameMatch = new Regex("^" + exactName + "$");
    }

    @ConfigDsl
    public final void fromMinLevel(@NotNull Level minLevel, @NotNull Function1<? super LevelRange, Unit> configBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)minLevel), (String)"minLevel");
        Intrinsics.checkNotNullParameter(configBlock, (String)"configBlock");
        LevelRange range = new LevelRange(minLevel, Level.FATAL);
        Object object = range;
        boolean bl = false;
        boolean bl2 = false;
        configBlock.invoke(object);
        object = range.getSinkNames$klogging();
        bl = false;
        if (!object.isEmpty()) {
            this.ranges.add(range);
        }
    }

    @ConfigDsl
    public final void atLevel(@NotNull Level level, @NotNull Function1<? super LevelRange, Unit> configBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(configBlock, (String)"configBlock");
        LevelRange range = new LevelRange(level, level);
        Object object = range;
        boolean bl = false;
        boolean bl2 = false;
        configBlock.invoke(object);
        object = range.getSinkNames$klogging();
        bl = false;
        if (!object.isEmpty()) {
            this.ranges.add(range);
        }
    }
}

