/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.events;

import io.klogging.events.Timestamp;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u0004\u001a\u00020\u0003\u00a8\u0006\u0005"}, d2={"iso", "", "timestamp", "Lio/klogging/events/Timestamp;", "now", "klogging"})
public final class TimestampKt {
    @NotNull
    public static final Timestamp now() {
        Instant instant = Instant.now();
        return new Timestamp(instant.getEpochSecond(), instant.getNano());
    }

    @NotNull
    public static final String iso(@NotNull Timestamp timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        String string = Instant.ofEpochSecond(timestamp.getEpochSeconds(), timestamp.getNanos()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ofEpochSecond(timestamp.epochSeconds, timestamp.nanos)\n        .toString()");
        return string;
    }
}

