/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.config;

import io.klogging.Level;
import io.klogging.config.ConfigDsl;
import io.klogging.config.KloggingConfigurationKt;
import io.klogging.config.LevelRange;
import io.klogging.config.LoggingConfig;
import io.klogging.config.SinkConfiguration;
import io.klogging.events.LogEvent;
import io.klogging.internal.InternalLoggingKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u0017J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\tH\u0007J!\u0010\u001a\u001a\u00020\u00152\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u001c\u00a2\u0006\u0002\b\u001dH\u0007J\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0010J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0011H\u0007J@\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00102\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00100\u001cj\u0002`%2\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u001cj\u0002`'H\u0007J\r\u0010(\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b)R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006*"}, d2={"Lio/klogging/config/KloggingConfiguration;", "", "()V", "configs", "", "Lio/klogging/config/LoggingConfig;", "getConfigs$klogging", "()Ljava/util/List;", "kloggingMinLogLevel", "Lio/klogging/Level;", "getKloggingMinLogLevel$klogging", "()Lio/klogging/Level;", "setKloggingMinLogLevel$klogging", "(Lio/klogging/Level;)V", "sinks", "", "", "Lio/klogging/config/SinkConfiguration;", "getSinks$klogging", "()Ljava/util/Map;", "append", "", "other", "append$klogging", "kloggingMinLevel", "minLevel", "logging", "configBlock", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "minimumLevelOf", "loggerName", "sink", "sinkName", "sinkConfig", "renderer", "Lio/klogging/events/LogEvent;", "Lio/klogging/rendering/RenderString;", "dispatcher", "Lio/klogging/dispatching/DispatchString;", "validateSinks", "validateSinks$klogging", "klogging"})
public final class KloggingConfiguration {
    @NotNull
    private final Map<String, SinkConfiguration> sinks;
    @NotNull
    private final List<LoggingConfig> configs;
    @NotNull
    private Level kloggingMinLogLevel;

    public KloggingConfiguration() {
        boolean bl = false;
        this.sinks = new LinkedHashMap();
        bl = false;
        this.configs = new ArrayList();
        this.kloggingMinLogLevel = KloggingConfigurationKt.getDefaultKloggingMinLogLevel();
    }

    @NotNull
    public final Map<String, SinkConfiguration> getSinks$klogging() {
        return this.sinks;
    }

    @NotNull
    public final List<LoggingConfig> getConfigs$klogging() {
        return this.configs;
    }

    @NotNull
    public final Level getKloggingMinLogLevel$klogging() {
        return this.kloggingMinLogLevel;
    }

    public final void setKloggingMinLogLevel$klogging(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"<set-?>");
        this.kloggingMinLogLevel = level;
    }

    @ConfigDsl
    public final void kloggingMinLevel(@NotNull Level minLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)minLevel), (String)"minLevel");
        this.kloggingMinLogLevel = minLevel;
    }

    @ConfigDsl
    public final void sink(@NotNull String sinkName, @NotNull SinkConfiguration sinkConfig) {
        Intrinsics.checkNotNullParameter((Object)sinkName, (String)"sinkName");
        Intrinsics.checkNotNullParameter((Object)sinkConfig, (String)"sinkConfig");
        Map<String, SinkConfiguration> map = this.sinks;
        boolean bl = false;
        map.put(sinkName, sinkConfig);
    }

    @ConfigDsl
    public final void sink(@NotNull String sinkName, @NotNull Function1<? super LogEvent, String> renderer, @NotNull Function1<? super String, Unit> dispatcher) {
        Intrinsics.checkNotNullParameter((Object)sinkName, (String)"sinkName");
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        Map<String, SinkConfiguration> map = this.sinks;
        SinkConfiguration sinkConfiguration = new SinkConfiguration(renderer, dispatcher);
        boolean bl = false;
        map.put(sinkName, sinkConfiguration);
    }

    @ConfigDsl
    public final void logging(@NotNull Function1<? super LoggingConfig, Unit> configBlock) {
        LoggingConfig loggingConfig;
        Intrinsics.checkNotNullParameter(configBlock, (String)"configBlock");
        LoggingConfig loggingConfig2 = loggingConfig = new LoggingConfig();
        boolean bl = false;
        boolean bl2 = false;
        configBlock.invoke((Object)loggingConfig2);
        this.configs.add(loggingConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Level minimumLevelOf(@NotNull String loggerName) {
        Comparable comparable;
        void $this$flatMapTo$iv$iv;
        LoggingConfig it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        Iterable $this$filter$iv = this.configs;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LoggingConfig)element$iv$iv;
            boolean bl = false;
            if (!it.getNameMatch$klogging().matches((CharSequence)loggerName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (LoggingConfig)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getRanges$klogging();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable iterable = (List)destination$iv$iv;
        boolean bl = false;
        iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            LevelRange it2 = (LevelRange)iterator.next();
            boolean bl2 = false;
            Comparable comparable2 = (Comparable)((Object)it2.getMinLevel());
            while (iterator.hasNext()) {
                LevelRange it3 = (LevelRange)iterator.next();
                $i$a$-minOfOrNull-KloggingConfiguration$minimumLevelOf$3 = false;
                Comparable comparable3 = (Comparable)((Object)it3.getMinLevel());
                if (comparable2.compareTo(comparable3) <= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Level level = (Level)((Object)comparable);
        return level == null ? Level.NONE : level;
    }

    public final void validateSinks$klogging() {
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.configs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (LoggingConfig)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((LoggingConfig)it).getRanges$klogging();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (LevelRange)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((LevelRange)it).getSinkNames$klogging();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set loggingSinks = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set extraSinks = SetsKt.minus((Set)loggingSinks, (Iterable)this.sinks.keySet());
        Iterable $this$forEach$iv = extraSinks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            InternalLoggingKt.warn$default("Sink `" + it2 + "` was not defined and will be ignored", null, 2, null);
        }
    }

    public final void append$klogging(@NotNull KloggingConfiguration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.sinks.putAll(other.sinks);
        this.configs.addAll((Collection<LoggingConfig>)other.configs);
        if (this.kloggingMinLogLevel.compareTo((Enum)other.kloggingMinLogLevel) > 0) {
            this.kloggingMinLogLevel = other.kloggingMinLogLevel;
        }
    }
}

