/*
 * Decompiled with CFR 0.152.
 */
package io.klogging;

import io.klogging.BaseLoggerKt;
import io.klogging.Level;
import io.klogging.events.LogEvent;
import io.klogging.internal.KloggingEngine;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J<\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00012\u0016\b\u0002\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0018"}, d2={"Lio/klogging/BaseLogger;", "", "name", "", "getName", "()Ljava/lang/String;", "eventFrom", "Lio/klogging/events/LogEvent;", "level", "Lio/klogging/Level;", "throwable", "", "eventObject", "contextItems", "", "isDebugEnabled", "", "isErrorEnabled", "isFatalEnabled", "isInfoEnabled", "isLevelEnabled", "isTraceEnabled", "isWarnEnabled", "minLevel", "klogging"})
public interface BaseLogger {
    @NotNull
    public String getName();

    @NotNull
    public Level minLevel();

    public boolean isLevelEnabled(@NotNull Level var1);

    public boolean isTraceEnabled();

    public boolean isDebugEnabled();

    public boolean isInfoEnabled();

    public boolean isWarnEnabled();

    public boolean isErrorEnabled();

    public boolean isFatalEnabled();

    @NotNull
    public LogEvent eventFrom(@NotNull Level var1, @Nullable Throwable var2, @Nullable Object var3, @NotNull Map<String, ? extends Object> var4);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            nArray[Level.NONE.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Level minLevel(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return KloggingEngine.INSTANCE.minimumLevelOf$klogging(this_.getName());
        }

        public static boolean isLevelEnabled(@NotNull BaseLogger this_, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            return WhenMappings.$EnumSwitchMapping$0[level.ordinal()] == 1 ? false : this_.minLevel().compareTo((Enum)level) <= 0;
        }

        public static boolean isTraceEnabled(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.isLevelEnabled(Level.TRACE);
        }

        public static boolean isDebugEnabled(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.isLevelEnabled(Level.DEBUG);
        }

        public static boolean isInfoEnabled(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.isLevelEnabled(Level.INFO);
        }

        public static boolean isWarnEnabled(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.isLevelEnabled(Level.WARN);
        }

        public static boolean isErrorEnabled(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.isLevelEnabled(Level.ERROR);
        }

        public static boolean isFatalEnabled(@NotNull BaseLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.isLevelEnabled(Level.FATAL);
        }

        @NotNull
        public static LogEvent eventFrom(@NotNull BaseLogger this_, @NotNull Level level, @Nullable Throwable throwable, @Nullable Object eventObject, @NotNull Map<String, ? extends Object> contextItems) {
            LogEvent logEvent;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter(contextItems, (String)"contextItems");
            if (eventObject instanceof LogEvent) {
                Throwable throwable2 = throwable;
                logEvent = ((LogEvent)eventObject).copyWith$klogging(level, (String)(throwable2 == null ? null : ExceptionsKt.stackTraceToString((Throwable)throwable2)), contextItems);
            } else {
                Pair pair = BaseLoggerKt.access$messageAndStackTrace(eventObject, throwable);
                String message = (String)pair.component1();
                String stackTrace = (String)pair.component2();
                logEvent = new LogEvent(null, null, null, this_.getName(), null, level, null, message, stackTrace, contextItems, 87, null);
            }
            return logEvent;
        }

        public static /* synthetic */ LogEvent eventFrom$default(BaseLogger baseLogger, Level level, Throwable throwable, Object object, Map map, int n, Object object2) {
            if (object2 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: eventFrom");
            }
            if ((n & 8) != 0) {
                map = MapsKt.emptyMap();
            }
            return baseLogger.eventFrom(level, throwable, object, map);
        }
    }
}

