/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.config;

import io.klogging.config.EnvironmentKt;
import io.klogging.internal.InternalLoggingKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\b\u0010\u0000\u001a\u0004\u0018\u00010\u0001\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u00a8\u0006\u0004"}, d2={"findJsonConfigText", "", "readResourceText", "resourcePath", "klogging"})
public final class FindJsonConfigTextKt {
    @Nullable
    public static final String readResourceText(@NotNull String resourcePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream(resourcePath);
        if (inputStream == null) {
            string = null;
        } else {
            BufferedReader bufferedReader;
            Closeable closeable = inputStream;
            closeable = new InputStreamReader((InputStream)closeable, Charsets.UTF_8);
            int n = 8192;
            BufferedReader it = bufferedReader = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            boolean bl = false;
            InternalLoggingKt.info$default("Configuration", "Reading JSON configuration from " + resourcePath + " on the classpath", null, 4, null);
            string = TextStreamsKt.readText((Reader)it);
        }
        return string;
    }

    @Nullable
    public static final String findJsonConfigText() {
        String string;
        String filePath = EnvironmentKt.getenv("KLOGGING_CONFIG_JSON_PATH");
        String string2 = filePath;
        if (string2 == null) {
            string = null;
        } else {
            Object it = string2;
            boolean bl = false;
            File file = new File((String)it);
            it = file;
            boolean bl2 = false;
            if (((File)it).exists()) {
                InternalLoggingKt.info$default("Configuration", Intrinsics.stringPlus((String)"Reading JSON configuration from ", (Object)filePath), null, 4, null);
                string = FilesKt.readText((File)it, (Charset)Charsets.UTF_8);
            } else {
                InternalLoggingKt.warn$default("Configuration", "Specified JSON configuration file " + filePath + " not found", null, 4, null);
                string = null;
            }
        }
        String string3 = string;
        return string3 == null ? FindJsonConfigTextKt.readResourceText("klogging.json") : string3;
    }
}

