# Module Klogging

Kotlin coroutine-based logging library.

# Package io.klogging

Base package containing interfaces and classes of the Klogging public API.

# Package io.klogging.config

Klogging configuration, from DSL or JSON files.

# Package io.klogging.context

`LogContext` class for storing information in a coroutine scope.

# Package io.klogging.events

Log event and timestamp classes.

# Package io.klogging.impl

Implementations of public logging APIs.

# Package io.klogging.internal

Internal ‘engine’ of Klogging, and the internal logger for diagnostics.

# Package io.klogging.rendering

Rendering log events as JSON or plain text.

# Package io.klogging.sending

Sending rendered log events to sinks.

# Package io.klogging.templating

Message template code, based on [Message Templates](https://messagetemplates.org).
