/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.runner.console;

import io.kotlintest.runner.console.ConsoleWriter;
import io.kotlintest.runner.console.DefaultConsoleWriter;
import io.kotlintest.runner.console.KotlinTestConsoleRunner;
import io.kotlintest.runner.console.TeamCityConsoleWriter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0019\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"defaultWriter", "Lio/kotlintest/runner/console/ConsoleWriter;", "main", "", "args", "", "", "([Ljava/lang/String;)V", "kotlintest-runner-console"})
public final class LauncherKt {
    public static final void main(@NotNull String[] args) {
        ConsoleWriter consoleWriter;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        ArgumentParser parser = ArgumentParsers.newFor((String)"kotlintest").build().defaultHelp(true).description("KotlinTest console runner");
        parser.addArgument(new String[]{"--test"}).help("Specify the test name to execute (can be a leaf test or a container test)");
        parser.addArgument(new String[]{"--spec"}).help("Specify the fully qualified name of the spec class which contains the test to execute");
        parser.addArgument(new String[]{"--writer"}).help("Specify the fully qualified name of the console writer implementation. Defaults to io.kotlintest.runner.console.TeamCityConsoleWriter");
        Namespace ns = parser.parseArgs(args);
        String writerClass = ns.getString("writer");
        String spec = ns.getString("spec");
        String test = ns.getString("test");
        if (writerClass == null) {
            consoleWriter = LauncherKt.defaultWriter();
        } else {
            Class<?> clazz = Class.forName(writerClass);
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(writerClass)");
            Object object = KClasses.createInstance((KClass)JvmClassMappingKt.getKotlinClass(clazz));
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.kotlintest.runner.console.ConsoleWriter");
            }
            consoleWriter = (ConsoleWriter)object;
        }
        ConsoleWriter writer = consoleWriter;
        KotlinTestConsoleRunner runner = new KotlinTestConsoleRunner(writer);
        runner.execute(spec, test);
        if (writer.hasErrors()) {
            System.exit(-1);
        }
    }

    @NotNull
    public static final ConsoleWriter defaultWriter() {
        ConsoleWriter consoleWriter;
        try {
            Class.forName("com.intellij.rt.execution.CommandLineWrapper");
            consoleWriter = new TeamCityConsoleWriter();
        }
        catch (ClassNotFoundException _) {
            consoleWriter = new DefaultConsoleWriter();
        }
        return consoleWriter;
    }
}

