/*
 * Copyright 2014-2019 JetBrains s.r.o and contributors. Use of this source code is governed by the Apache 2.0 license.
 */

package io.ktor.client.tests.utils

import io.ktor.client.engine.*

/**
 * Helper interface to test client.
 */
expect abstract class ClientLoader() {
    /**
     * Perform test against all clients from dependencies.
     */
    fun clientTests(
        skipPlatforms: List<String> = emptyList(),
        block: suspend TestClientBuilder<HttpClientEngineConfig>.() -> Unit
    )
}
