/*
 * Decompiled with CFR 0.152.
 */
package com.meltingice.caman;

import com.meltingice.caman.PluginType;
import com.meltingice.caman.exceptions.InvalidArgumentsException;
import com.meltingice.caman.exceptions.InvalidPluginException;
import java.util.LinkedList;

public abstract class CamanFilter {
    protected PluginType type = PluginType.PIXELWISE;
    protected LinkedList<Object> params = new LinkedList();

    public CamanFilter set(Object param) {
        this.params.add(param);
        return this;
    }

    public CamanFilter set(Object[] paramArr) {
        for (Object param : paramArr) {
            this.params.add(param);
        }
        return this;
    }

    public double getParamDouble(int num) {
        try {
            return (Double)this.params.get(num);
        }
        catch (Exception e) {
            return ((Integer)this.params.get(num)).doubleValue();
        }
    }

    public int getParamInt(int num) {
        try {
            return (Integer)this.params.get(num);
        }
        catch (Exception e) {
            return ((Double)this.params.get(num)).intValue();
        }
    }

    public void precomputeParams() throws InvalidArgumentsException {
    }

    public PluginType type() {
        return this.type;
    }

    protected void setType(PluginType type) {
        this.type = type;
    }

    public int[] process(int[] rgb) throws InvalidPluginException {
        throw new InvalidPluginException();
    }

    public double[] getKernel() throws InvalidPluginException {
        throw new InvalidPluginException();
    }
}

