/*
 * Decompiled with CFR 0.152.
 */
package com.meltingice.caman;

import com.meltingice.caman.CamanFilter;
import com.meltingice.caman.CamanPreset;
import com.meltingice.caman.CamanRenderer;
import com.meltingice.caman.Image;
import com.meltingice.caman.util.CamanUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class CamanJ {
    private Image image;
    private LinkedList<CamanFilter> filters;
    private boolean isRendered = false;

    public CamanJ(String file) {
        try {
            this.image = new Image(file);
        }
        catch (IOException e) {
            System.err.println("CamanJ: Unable to load image from file");
        }
        this.filters = new LinkedList();
    }

    public CamanJ(BufferedImage image) {
        try {
            this.image = new Image(image);
        }
        catch (IOException e) {
            System.err.println("CamanJ: Unable to load image from BufferedImagee");
        }
        this.filters = new LinkedList();
    }

    private CamanFilter loadFilter(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> c1 = Class.forName("com.meltingice.caman.filters." + CamanUtil.getClassName(name));
        CamanFilter plugin = (CamanFilter)c1.newInstance();
        System.out.println("CamanJ: loaded filter " + name);
        this.filters.add(plugin);
        return plugin;
    }

    private CamanPreset loadPreset(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> c1 = Class.forName("com.meltingice.caman.presets." + CamanUtil.getClassName(name));
        CamanPreset preset = (CamanPreset)c1.newInstance();
        System.out.println("CamanJ: loaded preset " + name);
        return preset;
    }

    public CamanFilter filter(String name) {
        try {
            CamanFilter plugin = this.loadFilter(name);
            this.isRendered = false;
            return plugin;
        }
        catch (Exception e) {
            System.err.println("CamanJ: Invalid filter name");
            return null;
        }
    }

    public void preset(String name) {
        try {
            CamanPreset preset = this.loadPreset(name);
            preset.apply(this);
        }
        catch (Exception e) {
            System.err.println("CamanJ: Unable to find or execute preset " + name);
        }
    }

    public void render() {
        CamanRenderer renderer = new CamanRenderer(this.image, this.filters);
        renderer.render();
        this.isRendered = true;
    }

    public BufferedImage save() {
        if (!this.isRendered) {
            this.render();
        }
        return this.image.getDestImage();
    }

    public void save(String outFile) {
        BufferedImage dest = this.save();
        String ext = outFile.substring(outFile.lastIndexOf(46) + 1, outFile.length());
        File file = new File(outFile);
        try {
            System.out.println("CamanJ: writing " + outFile + " to file");
            ImageIO.write((RenderedImage)dest, ext, file);
        }
        catch (IOException e) {
            System.err.println("CamanJ: error writing to file " + file.getName());
        }
    }
}

