/*
 * Decompiled with CFR 0.152.
 */
package com.meltingice.caman;

import com.meltingice.caman.CamanFilter;
import com.meltingice.caman.Image;
import com.meltingice.caman.PluginType;
import com.meltingice.caman.exceptions.InvalidArgumentsException;
import com.meltingice.caman.exceptions.InvalidPluginException;
import com.meltingice.caman.util.CamanUtil;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamanRenderer {
    private Image image;
    private LinkedList<CamanFilter> filters;
    private LinkedList<RenderThread> threads;
    private static int CONCURRENCY = Runtime.getRuntime().availableProcessors();

    public CamanRenderer(Image image, LinkedList<CamanFilter> filters) {
        this.image = image;
        this.filters = filters;
        this.threads = new LinkedList();
    }

    public static void setConcurrency(int level) {
        CONCURRENCY = level;
    }

    public void render() {
        int i;
        int blockHeight = this.image.getHeight() / CONCURRENCY;
        int lastBlockHeight = blockHeight + this.image.getHeight() % CONCURRENCY;
        long startTime = System.currentTimeMillis();
        for (i = 0; i < CONCURRENCY; ++i) {
            int start = i * blockHeight;
            int end = start + (i == CONCURRENCY - 1 ? lastBlockHeight : blockHeight);
            RenderThread thread = new RenderThread(start, end);
            thread.start();
            this.threads.add(thread);
        }
        for (i = 0; i < CONCURRENCY; ++i) {
            try {
                this.threads.get(i).join();
                System.out.println("CamanJ: block #" + i + " finished!");
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.filters.clear();
        this.threads.clear();
        long endTime = System.currentTimeMillis();
        System.out.println("CamanJ: render finished in " + (endTime - startTime) + "ms");
    }

    private class RenderThread
    extends Thread {
        private int start;
        private int end;

        public RenderThread(int start, int end) {
            this.start = start;
            this.end = end;
            System.out.println("CamanJ: render thread spawned! start = " + start + ", end = " + end);
        }

        public void run() {
            for (int i = 0; i < CamanRenderer.this.filters.size(); ++i) {
                CamanFilter filter = (CamanFilter)CamanRenderer.this.filters.get(i);
                try {
                    filter.precomputeParams();
                }
                catch (InvalidArgumentsException e) {
                    System.err.println("CamanJ: invalid arguments given to " + filter.getClass().getName());
                    continue;
                }
                if (filter.type() == PluginType.PIXELWISE) {
                    this.renderPixelwise(filter);
                    continue;
                }
                if (filter.type() != PluginType.KERNEL) continue;
                this.renderKernel(filter);
            }
        }

        private void renderPixelwise(CamanFilter filter) {
            try {
                for (int i = 0; i < CamanRenderer.this.image.getWidth(); ++i) {
                    for (int j = this.start; j < this.end; ++j) {
                        if (filter.type() != PluginType.PIXELWISE) continue;
                        CamanRenderer.this.image.setPixel(i, j, filter.process(CamanRenderer.this.image.getPixel(i, j)));
                    }
                }
            }
            catch (InvalidPluginException e) {
                System.err.println("CamanJ: Error executing filter " + filter.getClass().getName());
                return;
            }
        }

        private void renderKernel(CamanFilter filter) {
            try {
                int i;
                double[] adjust = filter.getKernel();
                int[][] kernel = new int[adjust.length][4];
                double divisor = 0.0;
                int[][][] destPixels = new int[CamanRenderer.this.image.getWidth()][CamanRenderer.this.image.getHeight()][4];
                for (i = 0; i < adjust.length; ++i) {
                    divisor += adjust[i];
                }
                for (int y = this.start; y < this.end; ++y) {
                    int width = CamanRenderer.this.image.getWidth();
                    for (int x = 0; x < width; ++x) {
                        kernel = CamanUtil.buildKernel(CamanRenderer.this.image, adjust.length, x, y);
                        for (int i2 = 0; i2 < kernel.length; ++i2) {
                            int[] nArray = destPixels[x][y];
                            nArray[0] = nArray[0] + (int)(adjust[i2] * (double)kernel[i2][0]);
                            int[] nArray2 = destPixels[x][y];
                            nArray2[1] = nArray2[1] + (int)(adjust[i2] * (double)kernel[i2][1]);
                            int[] nArray3 = destPixels[x][y];
                            nArray3[2] = nArray3[2] + (int)(adjust[i2] * (double)kernel[i2][2]);
                        }
                        int[] nArray = destPixels[x][y];
                        nArray[0] = (int)((double)nArray[0] / divisor);
                        int[] nArray4 = destPixels[x][y];
                        nArray4[1] = (int)((double)nArray4[1] / divisor);
                        int[] nArray5 = destPixels[x][y];
                        nArray5[2] = (int)((double)nArray5[2] / divisor);
                        destPixels[x][y][3] = 255;
                    }
                }
                for (i = 0; i < CamanRenderer.this.image.getWidth(); ++i) {
                    for (int j = this.start; j < this.end; ++j) {
                        CamanRenderer.this.image.setPixel(i, j, CamanUtil.clampRGB(destPixels[i][j]));
                    }
                }
            }
            catch (InvalidPluginException invalidPluginException) {
                // empty catch block
            }
        }
    }
}

