/*
 * Decompiled with CFR 0.152.
 */
package com.meltingice.caman;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Image {
    private String filename;
    private BufferedImage image;
    public int[] pixels;

    public Image(String file) throws IOException {
        this.filename = file;
        this.prepare();
    }

    public Image(BufferedImage inputImage) throws IOException {
        this.image = inputImage;
        this.pixels = new int[this.getWidth() * this.getHeight()];
        this.image.getRGB(0, 0, this.getWidth(), this.getHeight(), this.pixels, 0, this.getWidth());
    }

    private void prepare() throws IOException {
        this.image = ImageIO.read(new File(this.filename));
        this.pixels = new int[this.getWidth() * this.getHeight()];
        this.image.getRGB(0, 0, this.getWidth(), this.getHeight(), this.pixels, 0, this.getWidth());
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public int getPixelRGB(int x, int y) {
        int index = this.xyToIndex(x, y);
        return this.pixels[index] << 24 | this.pixels[index] << 16 | this.pixels[index] << 8 | this.pixels[index];
    }

    public BufferedImage getDestImage() {
        this.image.setRGB(0, 0, this.getWidth(), this.getHeight(), this.pixels, 0, this.getWidth());
        return this.image;
    }

    public int[] getPixel(int x, int y) {
        int index = this.xyToIndex(x, y);
        return new int[]{this.pixels[index] >> 16 & 0xFF, this.pixels[index] >> 8 & 0xFF, this.pixels[index] & 0xFF};
    }

    public void setPixel(int x, int y, int[] rgb) {
        int index = this.xyToIndex(x, y);
        this.pixels[index] = 0xFF000000 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    private int xyToIndex(int x, int y) {
        return y * this.getWidth() + x;
    }
}

