/*
 * Decompiled with CFR 0.152.
 */
package com.meltingice.caman.filters;

import com.meltingice.caman.CamanFilter;
import com.meltingice.caman.exceptions.InvalidArgumentsException;
import com.meltingice.caman.util.CamanUtil;

public class Channels
extends CamanFilter {
    private double[] args;

    public void precomputeParams() throws InvalidArgumentsException {
        this.args = new double[3];
        for (int i = 0; i < 3; ++i) {
            try {
                this.args[i] = this.getParamDouble(i) / 100.0;
                continue;
            }
            catch (Exception e) {
                this.args[i] = 0.0;
            }
        }
    }

    public int[] process(int[] rgb) {
        double[] drgb = CamanUtil.toDouble(rgb);
        for (int i = 0; i < 3; ++i) {
            if (this.args[i] > 0.0) {
                int n = i;
                drgb[n] = drgb[n] + (255.0 - drgb[i]) * this.args[i];
                continue;
            }
            int n = i;
            drgb[n] = drgb[n] - drgb[i] * Math.abs(this.args[i]);
        }
        return CamanUtil.clampRGB(drgb);
    }
}

