/*
 * Decompiled with CFR 0.152.
 */
package com.meltingice.caman.filters;

import com.meltingice.caman.CamanFilter;
import com.meltingice.caman.exceptions.InvalidArgumentsException;
import com.meltingice.caman.util.CamanUtil;
import com.meltingice.caman.util.ColorUtil;

public class Colorize
extends CamanFilter {
    private int[] adjustRGB;
    private double amt;

    public void precomputeParams() throws InvalidArgumentsException {
        if (this.params.size() == 2) {
            this.adjustRGB = ColorUtil.hexToRgb((String)this.params.get(0));
            this.amt = this.getParamDouble(1) / 100.0;
        } else if (this.params.size() == 4) {
            this.adjustRGB = new int[]{this.getParamInt(0), this.getParamInt(1), this.getParamInt(2)};
            this.amt = this.getParamDouble(3) / 100.0;
        } else {
            throw new InvalidArgumentsException();
        }
    }

    public int[] process(int[] rgb) {
        for (int i = 0; i < 3; ++i) {
            int n = i;
            rgb[n] = (int)((double)rgb[n] - (double)(rgb[i] - this.adjustRGB[i]) * this.amt);
        }
        return CamanUtil.clampRGB(rgb);
    }
}

