/*
 * Decompiled with CFR 0.152.
 */
package com.meltingice.caman.filters;

import com.meltingice.caman.CamanFilter;
import com.meltingice.caman.exceptions.InvalidArgumentsException;
import com.meltingice.caman.util.Bezier;
import com.meltingice.caman.util.CamanUtil;

public class Curves
extends CamanFilter {
    private int[] channels;
    private Bezier bezier;

    public void precomputeParams() throws InvalidArgumentsException {
        if (this.params.size() != 9) {
            throw new InvalidArgumentsException();
        }
        this.channels = CamanUtil.channelsToIntArray((String)this.params.get(0));
        int[] start = new int[]{this.getParamInt(1), this.getParamInt(2)};
        int[] ctrl1 = new int[]{this.getParamInt(3), this.getParamInt(4)};
        int[] ctrl2 = new int[]{this.getParamInt(5), this.getParamInt(6)};
        int[] end = new int[]{this.getParamInt(7), this.getParamInt(8)};
        this.bezier = new Bezier(start, ctrl1, ctrl2, end, 0, 255);
        this.bezier.fillEnds(0, 255);
    }

    public int[] process(int[] rgb) {
        for (int i = 0; i < this.channels.length; ++i) {
            rgb[this.channels[i]] = this.bezier.query(rgb[this.channels[i]]);
        }
        return CamanUtil.clampRGB(rgb);
    }
}

