/*
 * Decompiled with CFR 0.152.
 */
package com.meltingice.caman.filters;

import com.meltingice.caman.CamanFilter;
import com.meltingice.caman.util.Bezier;
import com.meltingice.caman.util.CamanUtil;

public class Exposure
extends CamanFilter {
    private Bezier bezier;

    public void precomputeParams() {
        int adjust = this.getParamInt(0);
        double p = (double)Math.abs(adjust) / 100.0;
        Integer[] ctrl1 = new Integer[]{0, (int)(255.0 * p)};
        Integer[] ctrl2 = new Integer[]{(int)(255.0 - 255.0 * p), 255};
        if (adjust < 0) {
            ctrl1 = CamanUtil.reverseArray(ctrl1);
            ctrl2 = CamanUtil.reverseArray(ctrl2);
        }
        this.bezier = new Bezier(new int[]{0, 0}, new int[]{ctrl1[0], ctrl1[1]}, new int[]{ctrl2[0], ctrl2[1]}, new int[]{255, 255});
    }

    public int[] process(int[] rgb) {
        for (int i = 0; i < 3; ++i) {
            rgb[i] = this.bezier.query(rgb[i]);
        }
        return CamanUtil.clampRGB(rgb);
    }
}

