/*
 * Decompiled with CFR 0.152.
 */
package com.meltingice.caman.util;

import java.util.HashMap;

public class Bezier {
    private int[] start;
    private int[] ctrl1;
    private int[] ctrl2;
    private int[] end;
    private int lowBound;
    private int highBound;
    private int iterations = 1000;
    private HashMap<Integer, Integer> bezier;

    public Bezier(int[] start, int[] ctrl1, int[] ctrl2, int[] end, int lowBound, int highBound) {
        this.start = start;
        this.ctrl1 = ctrl1;
        this.ctrl2 = ctrl2;
        this.end = end;
        this.lowBound = lowBound;
        this.highBound = highBound;
        this.bezier = new HashMap();
        this.solve();
    }

    public Bezier(int[] start, int[] ctrl1, int[] ctrl2, int[] end) {
        this.start = start;
        this.ctrl1 = ctrl1;
        this.ctrl2 = ctrl2;
        this.end = end;
        this.lowBound = Integer.MIN_VALUE;
        this.highBound = Integer.MAX_VALUE;
        this.bezier = new HashMap();
        this.solve();
    }

    public void setIterations(int iter) {
        this.iterations = iter;
    }

    public void fillEnds(int s, int e) {
        int i;
        if (this.start[0] > s) {
            for (i = 0; i < this.start[0]; ++i) {
                this.bezier.put(i, this.start[1]);
            }
        }
        if (this.end[0] < e) {
            for (i = this.end[0]; i <= 255; ++i) {
                this.bezier.put(i, this.end[1]);
            }
        }
    }

    public int query(int x) {
        return this.bezier.get(x);
    }

    private void solve() {
        double x0 = this.start[0];
        double x1 = this.ctrl1[0];
        double x2 = this.ctrl2[0];
        double x3 = this.end[0];
        double y0 = this.start[1];
        double y1 = this.ctrl1[1];
        double y2 = this.ctrl2[1];
        double y3 = this.end[1];
        double Cx = 3.0 * (x1 - x0);
        double Bx = 3.0 * (x2 - x1) - Cx;
        double Ax = x3 - x0 - Cx - Bx;
        double Cy = 3.0 * (y1 - y0);
        double By = 3.0 * (y2 - y1) - Cy;
        double Ay = y3 - y0 - Cy - By;
        for (int i = 0; i < this.iterations; ++i) {
            double t = (double)i / (double)this.iterations;
            int curveX = (int)Math.round(Ax * Math.pow(t, 3.0) + Bx * Math.pow(t, 2.0) + Cx * t + x0);
            int curveY = (int)Math.round(Ay * Math.pow(t, 3.0) + By * Math.pow(t, 2.0) + Cy * t + y0);
            if (curveY < this.lowBound) {
                curveY = this.lowBound;
            } else if (curveY > this.highBound) {
                curveY = this.highBound;
            }
            this.bezier.put(curveX, curveY);
        }
        double[] leftCoord = new double[2];
        double[] rightCoord = new double[2];
        if (this.bezier.size() < this.end[0] + 1) {
            for (int i = this.start[0]; i <= this.end[0]; ++i) {
                if (this.bezier.containsKey(i)) continue;
                leftCoord[0] = i - 1;
                leftCoord[1] = this.bezier.get(i - 1).intValue();
                for (int j = i; j <= this.end[0]; ++j) {
                    if (this.bezier.containsKey(j)) continue;
                    rightCoord[0] = j;
                    rightCoord[1] = this.bezier.get(j).intValue();
                    break;
                }
                this.bezier.put(i, (int)(leftCoord[1] + (rightCoord[1] - leftCoord[1]) / (rightCoord[0] - leftCoord[0]) * ((double)i - leftCoord[0])));
            }
        }
        if (!this.bezier.containsKey(this.end[0])) {
            this.bezier.put(this.end[0], this.bezier.get(this.end[0] - 1));
        }
    }
}

