/*
 * Decompiled with CFR 0.152.
 */
package com.meltingice.caman.util;

import com.meltingice.caman.Image;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamanUtil {
    public static int clampRGB(int val) {
        if (val < 0) {
            return 0;
        }
        if (val > 255) {
            return 255;
        }
        return val;
    }

    public static int[] clampRGB(int[] rgb) {
        rgb[0] = CamanUtil.clampRGB(rgb[0]);
        rgb[1] = CamanUtil.clampRGB(rgb[1]);
        rgb[2] = CamanUtil.clampRGB(rgb[2]);
        return rgb;
    }

    public static int[] clampRGB(double[] drgb) {
        int[] rgb = new int[4];
        rgb[0] = CamanUtil.clampRGB((int)drgb[0]);
        rgb[1] = CamanUtil.clampRGB((int)drgb[1]);
        rgb[2] = CamanUtil.clampRGB((int)drgb[2]);
        return rgb;
    }

    public static double[] toDouble(int[] rgb) {
        return new double[]{rgb[0], rgb[1], rgb[2]};
    }

    public static String getClassName(String input) {
        if (input.length() == 0) {
            return input;
        }
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }

    public static double randomRange(double min, double max) {
        return min + Math.random() * (max - min + 1.0);
    }

    public static int randomRange(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public static int[] channelsToIntArray(String chans) {
        int[] result = new int[chans.length()];
        for (int i = 0; i < chans.length(); ++i) {
            char c = chans.charAt(i);
            if (c == 'r') {
                result[i] = 0;
                continue;
            }
            if (c == 'g') {
                result[i] = 1;
                continue;
            }
            if (c != 'b') continue;
            result[i] = 2;
        }
        return result;
    }

    public static <T> T[] reverseArray(T[] arr) {
        List<T> list = Arrays.asList(arr);
        Collections.reverse(list);
        return list.toArray();
    }

    public static int[][] buildKernel(Image image, int kernelSize, int x, int y) {
        int[][] kernel = new int[kernelSize][4];
        int builder = ((int)Math.sqrt(kernelSize) - 1) / 2;
        int builderIndex = 0;
        for (int j = -builder; j <= builder; ++j) {
            for (int i = -builder; i <= builder; ++i) {
                try {
                    kernel[builderIndex] = image.getPixel(x + i, y + j);
                }
                catch (Exception e) {
                    kernel[builderIndex] = new int[]{0, 0, 0, 255};
                }
                ++builderIndex;
            }
        }
        return kernel;
    }
}

