/*
 * Decompiled with CFR 0.152.
 */
package com.meltingice.caman.util;

import com.meltingice.caman.util.CamanUtil;

public class ColorUtil {
    public static double[] rgbToHsv(int[] rgb) {
        double[] drgb = CamanUtil.toDouble(rgb);
        drgb[0] = drgb[0] / 255.0;
        drgb[1] = drgb[1] / 255.0;
        drgb[2] = drgb[2] / 255.0;
        double max = Math.max(Math.max(drgb[0], drgb[1]), drgb[2]);
        double min = Math.min(Math.min(drgb[0], drgb[1]), drgb[2]);
        double h = max;
        double s = max;
        double v = max;
        double d = max - min;
        double d2 = s = max == 0.0 ? 0.0 : d / max;
        if (max == min) {
            h = 0.0;
        } else {
            if (max == (double)rgb[0]) {
                h = (double)(rgb[1] - rgb[2]) / d + (double)(rgb[1] < rgb[2] ? 6 : 0);
            } else if (max == (double)rgb[1]) {
                h = (double)(rgb[2] - rgb[0]) / d + 2.0;
            } else if (max == (double)rgb[2]) {
                h = (double)(rgb[0] - rgb[1]) / d + 4.0;
            }
            h /= 6.0;
        }
        return new double[]{h, s, v};
    }

    public static int[] hsvToRgb(double[] hsv) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        double i = Math.floor(hsv[0] * 6.0);
        double f = hsv[0] * 6.0 - i;
        double p = hsv[2] * (1.0 - hsv[1]);
        double q = hsv[2] * (1.0 - f * hsv[1]);
        double t = hsv[2] * (1.0 - (1.0 - f) * hsv[1]);
        int mod = (int)i % 6;
        if (mod == 0) {
            r = hsv[2];
            g = t;
            b = p;
        } else if (mod == 1) {
            r = q;
            g = hsv[2];
            b = p;
        } else if (mod == 2) {
            r = p;
            g = hsv[2];
            b = t;
        } else if (mod == 3) {
            r = p;
            g = q;
            b = hsv[2];
        } else if (mod == 4) {
            r = t;
            g = p;
            b = hsv[2];
        } else if (mod == 5) {
            r = hsv[2];
            g = p;
            b = q;
        }
        return new int[]{(int)(r *= 255.0), (int)(g *= 255.0), (int)(b *= 255.0), 255};
    }

    public static int[] hexToRgb(String hex) {
        if (hex.charAt(0) == '#') {
            hex = hex.substring(1);
        }
        int[] rgb = new int[]{Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4, 6), 16)};
        return rgb;
    }
}

